% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpdensity_methods.R
\name{plot.lpdensity}
\alias{plot.lpdensity}
\title{Plot Method for Local Polynomial Density Estimation and Inference}
\usage{
\method{plot}{lpdensity}(
  ...,
  alpha = NULL,
  type = NULL,
  lty = NULL,
  lwd = NULL,
  lcol = NULL,
  pty = NULL,
  pwd = NULL,
  pcol = NULL,
  grid = NULL,
  CItype = NULL,
  CIuniform = FALSE,
  CIsimul = 2000,
  CIshade = NULL,
  CIcol = NULL,
  hist = FALSE,
  histData = NULL,
  histBreaks = NULL,
  histFillCol = 3,
  histFillShade = 0.2,
  histLineCol = "white",
  title = "",
  xlabel = "",
  ylabel = "",
  legendTitle = NULL,
  legendGroups = NULL
)
}
\arguments{
\item{...}{Class "lpdensity" object, obtained from calling \code{\link{lpdensity}}.}

\item{alpha}{Numeric scalar between 0 and 1, specifies the significance level for plotting
confidence intervals/bands. If more than one is provided, they will be applied to each data series
accordingly.}

\item{type}{String, one of \code{"line"} (default), \code{"points"} and \code{"both"}, specifies how
the point estimates are plotted. If more than one is provided, they will be applied to each data series
accordingly.}

\item{lty}{Line type for point estimates, only effective if \code{type} is \code{"line"} or
\code{"both"}. \code{1} for solid line, \code{2} for dashed line, \code{3} for dotted line.
For other options, see the instructions for \code{\link{ggplot2}} or \code{\link{par}}. If
more than one is provided, they will be applied to each data series accordingly.}

\item{lwd}{Line width for point estimates, only effective if \code{type} is \code{"line"} or
\code{"both"}. Should be strictly positive. For other options, see the instructions for
\code{\link{ggplot2}} or \code{\link{par}}. If more than one is provided, they will be applied
to each data series accordingly.}

\item{lcol}{Line color for point estimates, only effective if \code{type} is \code{"line"} or
\code{"both"}. \code{1} for black, \code{2} for red, \code{3} for green, \code{4} for blue.
For other options, see the instructions for \code{\link{ggplot2}} or \code{\link{par}}. If
more than one is provided, they will be applied to each data series
accordingly.}

\item{pty}{Scatter plot type for point estimates, only effective if \code{type} is \code{"points"} or
\code{"both"}. For options, see the instructions for \code{\link{ggplot2}} or \code{\link{par}}. If
more than one is provided, they will be applied to each data series
accordingly.}

\item{pwd}{Scatter plot size for point estimates, only effective if \code{type} is \code{"points"} or
\code{"both"}. Should be strictly positive. If more than one is provided, they will be applied to each data series
accordingly.}

\item{pcol}{Scatter plot color for point estimates, only effective if \code{type} is \code{"points"} or
\code{"both"}. \code{1} for black, \code{2} for red, \code{3}
for green, \code{4} for blue.
For other options, see the instructions for \code{\link{ggplot2}} or \code{\link{par}}. If
more than one is provided, they will be applied to each data series
accordingly.}

\item{grid}{Numeric vector, specifies a subset of grid points
to plot point estimates.}

\item{CItype}{String, one of \code{"region"} (shaded region, default), \code{"line"} (dashed lines),
\code{"ebar"} (error bars), \code{"all"} (all of the previous) or \code{"none"} (no confidence region),
how the confidence region should be plotted. If more than one is provided, they will be applied to each data series
accordingly.}

\item{CIuniform}{\code{TRUE} or \code{FALSE} (default), plotting either pointwise confidence intervals (\code{FALSE}) or
uniform confidence bands (\code{TRUE}).}

\item{CIsimul}{Positive integer, specifies the number of simulations used to construct critical values (default is \code{2000}). This
option is ignored if \code{CIuniform=FALSE}.}

\item{CIshade}{Numeric, specifies the opaqueness of the confidence region, should be between 0 (transparent) and
1. Default is 0.2. If more than one is provided, they will be applied to each data series
accordingly.}

\item{CIcol}{Color of the confidence region. \code{1} for black, \code{2} for red, \code{3}
for green, \code{4} for blue.
For other options, see the instructions for \code{\link{ggplot2}} or \code{\link{par}}. If
more than one is provided, they will be applied to each data series
accordingly.}

\item{hist}{\code{TRUE} or \code{FALSE} (default), specifies whether a histogram should be added to the background.}

\item{histData}{Numeric vector, specifies the data used to construct the histogram plot.}

\item{histBreaks}{Numeric vector, specifies the breakpoints between histogram cells.}

\item{histFillCol}{Color of the histogram cells.}

\item{histFillShade}{Opaqueness of the histogram cells, should be between 0 (transparent) and
1. Default is 0.2.}

\item{histLineCol}{Color of the histogram lines.}

\item{title, xlabel, ylabel}{Strings, specifies the title of the plot and labels for the x- and y-axis.}

\item{legendTitle}{String, specifies the legend title.}

\item{legendGroups}{String vector, specifies the group names used in legend.}
}
\value{
\item{}{A stadnard \code{ggplot} object is returned, hence can be used for further customization.}
}
\description{
The plot method for local polynomial density objects.
}
\examples{
# Generate a random sample
set.seed(42); X <- rnorm(2000)

# Generate a density discontinuity at 0
X <- X - 0.5; X[X>0] <- X[X>0] * 2

# Density estimation, left of 0 (scaled by the relative sample size)
est1 <- lpdensity(data = X[X<=0], grid = seq(-2.5, 0, 0.05), bwselect = "imse-dpi",
  scale = sum(X<=0)/length(X))
# Density estimation, right of 0 (scaled by the relative sample size)
est2 <- lpdensity(data = X[X>0],  grid = seq(0, 2, 0.05), bwselect = "imse-dpi",
  scale = sum(X>0)/length(X))

# Plot
plot(est1, est2, legendTitle="My Plot", legendGroups=c("Left", "Right"))

# Plot uniform confidence bands
set.seed(42) # fix the seed for simulating critical values
plot(est1, est2, legendTitle="My Plot", legendGroups=c("Left", "Right"), CIuniform=TRUE)

# Adding a histogram to the background
plot(est1, est2, legendTitle="My Plot", legendGroups=c("Left", "Right"),
  hist=TRUE, histBreaks=seq(-2.4, 2, 0.2), histData=X)

# Plot point estimates for a subset of evaluation points
plot(est1, est2, legendTitle="My Plot", legendGroups=c("Left", "Right"),
  type="both", CItype="all", grid=seq(-2, 2, 0.5))
}
\seealso{
\code{\link{lpdensity}} for local polynomial density estimation.

Supported methods: \code{\link{coef.lpdensity}}, \code{\link{confint.lpdensity}},
  \code{\link{plot.lpdensity}}, \code{\link{print.lpdensity}}, \code{\link{summary.lpdensity}},
  \code{\link{vcov.lpdensity}}.
}
\author{
Matias D. Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.

Michael Jansson, University of California Berkeley. \email{mjansson@econ.berkeley.edu}.

Xinwei Ma (maintainer), University of California San Diego. \email{x1ma@ucsd.edu}.
}
