% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbs_for_lists.R
\name{mutate_.list}
\alias{mutate_.list}
\alias{mutate_.pairlist}
\alias{rename_.list}
\alias{rename_.pairlist}
\alias{select_.list}
\alias{select_.pairlist}
\alias{transmute_.list}
\alias{transmute_.pairlist}
\title{Dplyr verbs for lists and pairlists}
\usage{
\method{mutate_}{list}(.data, ..., .dots)

\method{mutate_}{pairlist}(.data, ..., .dots)

\method{rename_}{list}(.data, ..., .dots)

\method{rename_}{pairlist}(.data, ..., .dots)

\method{select_}{list}(.data, ..., .dots)

\method{select_}{pairlist}(.data, ..., .dots)

\method{transmute_}{list}(.data, ..., .dots)

\method{transmute_}{pairlist}(.data, ..., .dots)
}
\arguments{
\item{.data}{A list or pairlist.}

\item{...}{Comma separated list of unquoted expressions.}

\item{.dots}{Used to work around non-standard evaluation.}
}
\value{
A list or a pairlist.
}
\description{
We add methods for the verbs \code{\link[dplyr]{mutate}}, 
\code{\link[dplyr]{rename}}, \code{\link[dplyr]{select}}, 
and \code{\link[dplyr]{transmute}}.
}
\examples{
xs <- list(x1 = 1:3, 
           x2 = 2:5, 
           x3 = list("alpha", c("beta", "gamma")))

# Non-standard evaluation
mutate(xs, x4 = 4)
rename(xs, x0 = x1)
select(xs, -x3)
transmute(xs, x5 = 5)

# Standard evaluation
mutate_(xs, x4 = ~ 4)
rename_(xs, x0 = ~ x1)
select_(xs, ~ (-x3))
transmute_(xs, x5 = ~ 5)

}
\seealso{
\code{\link[dplyr]{mutate}},  
\code{\link[dplyr]{rename}}, 
\code{\link[dplyr]{select}},  
\code{\link[dplyr]{transmute}} from package \pkg{dplyr}.
}

