% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{covrmst}
\alias{covrmst}
\title{Covariance Between Restricted Mean Survival Times}
\usage{
covrmst(
  t2 = NA_real_,
  tau1 = NA_real_,
  tau2 = NA_real_,
  allocationRatioPlanned = 1,
  accrualTime = 0L,
  accrualIntensity = NA_real_,
  piecewiseSurvivalTime = 0L,
  lambda1 = NA_real_,
  lambda2 = NA_real_,
  gamma1 = 0L,
  gamma2 = 0L,
  accrualDuration = NA_real_,
  maxFollowupTime = NA_real_
)
}
\arguments{
\item{t2}{The calendar time for analysis 2.}

\item{tau1}{The milestone time for analysis 1.}

\item{tau2}{The milestone time for analysis 2.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{accrualTime}{A vector that specifies the starting time of
piecewise Poisson enrollment time intervals. Must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities. One for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{lambda1}{A vector of hazard rates for the event for the
active treatment group. One for each analysis time interval.}

\item{lambda2}{A vector of hazard rates for the event for the
control group. One for each analysis time interval.}

\item{gamma1}{The hazard rate for exponential dropout, or a vector of
hazard rates for piecewise exponential dropout for the active
treatment group.}

\item{gamma2}{The hazard rate for exponential dropout, or a vector of
hazard rates for piecewise exponential dropout for the control group.}

\item{accrualDuration}{Duration of the enrollment period.}

\item{maxFollowupTime}{Follow-up time for the first enrolled subject.
For fixed followup, \code{maxFollowupTime = minFollowupTime}.
For variable followup,
\code{maxFollowupTime = accrualDuration + minFollowupTime}.}
}
\value{
The covariance between the restricted mean survival times
for each treatment group.
}
\description{
Obtains the covariance between restricted mean survival
times at two different time points.
}
\examples{

covrmst(t2 = 25, tau1 = 16, tau2 = 18, allocationRatioPlanned = 1,
        accrualTime = c(0, 3), accrualIntensity = c(10, 20),
        piecewiseSurvivalTime = c(0, 6),
        lambda1 = c(0.0533, 0.0309), lambda2 = c(0.0533, 0.0533),
        gamma1 = -log(1-0.05)/12, gamma2 = -log(1-0.05)/12,
        accrualDuration = 12, maxFollowupTime = 30)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
