% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignMeans.R
\name{getDesignMeanDiffCarryover}
\alias{getDesignMeanDiffCarryover}
\title{Power and Sample Size for Direct Treatment Effects in Crossover
Trials}
\usage{
getDesignMeanDiffCarryover(
  beta = NA_real_,
  n = NA_real_,
  trtpair = NA_real_,
  carryover = TRUE,
  meanDiffH0 = 0,
  meanDiff = 0.5,
  stDev = 1,
  corr = 0.5,
  design = NA_real_,
  cumdrop = NA_real_,
  allocationRatioPlanned = NA_real_,
  normalApproximation = FALSE,
  rounding = TRUE,
  alpha = 0.025
)
}
\arguments{
\item{beta}{The type II error.}

\item{n}{The total sample size.}

\item{trtpair}{The treatment pair of interest to power the study.
If not given, it defaults to comparing the first treatment to the
last treatment.}

\item{carryover}{Whether to account for carryover effects in the
power calculation. Defaults to TRUE.}

\item{meanDiffH0}{The mean difference for the treatment pair of interest
under the null hypothesis. Defaults to 0.}

\item{meanDiff}{The mean difference for the treatment pair of interest
under the alternative hypothesis.}

\item{stDev}{The standard deviation for within-subject random error.}

\item{corr}{The intra-subject correlation due to subject random effect.}

\item{design}{The crossover design represented by a matrix with
rows indexing the sequences, columns indexing the periods, and
matrix entries indicating the treatments.}

\item{cumdrop}{The cumulative dropout rate over periods.}

\item{allocationRatioPlanned}{Allocation ratio for the sequences.
Defaults to equal randomization if not provided.}

\item{normalApproximation}{The type of computation of the p-values.
If \code{TRUE}, the variance is assumed to be known, otherwise
the calculations are performed with the t distribution.}

\item{rounding}{Whether to round up the sample size. Defaults to TRUE for
sample size rounding.}

\item{alpha}{The one-sided significance level. Defaults to 0.025.}
}
\value{
An S3 class \code{designMeanDiffCarryover} object with the
following components:
\itemize{
\item \code{power}: The power to reject the null hypothesis.
\item \code{alpha}: The one-sided significance level.
\item \code{numberOfSubjects}: The maximum number of subjects.
\item \code{trtpair}: The treatment pair of interest to power the study.
\item \code{carryover}: Whether to account for carryover effects in
the power calculation.
\item \code{meanDiffH0}: The mean difference for the treatment pair of
interest under the null hypothesis.
\item \code{meanDiff}: The mean difference for the treatment pair of
interest under the alternative hypothesis.
\item \code{stDev}: The standard deviation for within-subject random error.
\item \code{corr}: The intra-subject correlation due to subject random effect.
\item \code{design}: The crossover design represented by a matrix with
rows indexing the sequences, columns indexing the periods, and
matrix entries indicating the treatments.
\item \code{designMatrix}: The design matrix accounting for intercept,
sequence, period, direct treatment effects and carryover treatment
effects when \code{carryover = TRUE}, or the design matrix
accounting for intercept, sequence, period, and direct treatment
effects when \code{carryover = FALSE}.
\item \code{nseq}: The number of sequences.
\item \code{nprd}: The number of periods.
\item \code{ntrt}: The number of treatments.
\item \code{cumdrop}: The cumulative dropout rate over periods.
\item \code{V_direct_only}: The covariance matrix for direct treatment
effects without accounting for carryover effects. The treatment
comparisons for the covariance matrix are for the first \eqn{t-1}
treatments relative to the last treatment.
\item \code{V_direct_carry}: The covariance matrix for direct and
carryover treatment effects.
\item \code{v_direct_only}: The variance of the direct treatment effect for
the treatment pair of interest without accounting for carryover
effects.
\item \code{v_direct}: The variance of the direct treatment effect for
the treatment pair of interest accounting for carryover effects.
\item \code{v_carry}: The variance of the carryover treatment effect for
the treatment pair of interest.
\item \code{releff_direct}: The relative efficiency of the design
for estimating the direct treatment effect for the treatment pair
of interest after accounting for carryover effects with respect to
that without accounting for carryover effects. This is equal to
\code{v_direct_only/v_direct}.
\item \code{releff_carry}: The relative efficiency of the design
for estimating the carryover effect for the treatment pair
of interest. This is equal to \code{v_direct_only/v_carry}.
\item \code{allocationRatioPlanned}: Allocation ratio for the sequences.
\item \code{normalApproximation}: The type of computation of the p-values.
If \code{TRUE}, the variance is assumed to be known, otherwise
the calculations are performed with the t distribution.
\item \code{rounding}: Whether to round up the sample size.
}
}
\description{
Obtains the power and sample size for direct treatment
effects in crossover trials accounting or without accounting for
carryover effects.
}
\details{
The linear mixed-effects model to assess the direct treatment effects
in the presence of carryover treatment effects is given by
\deqn{y_{ijk} = \mu + \alpha_i + b_{ij} + \gamma_k + \tau_{d(i,k)}
+ \lambda_{c(i,k-1)} + e_{ijk},}
\deqn{i=1,\ldots,n; j=1,\ldots,r_i; k = 1,\ldots,p; d,c = 1,\ldots,t,}
where \eqn{\mu} is the general mean, \eqn{\alpha_i} is the effect of
the \eqn{i}th treatment sequence, \eqn{b_{ij}} is the random effect
with variance \eqn{\sigma_b^2} for the \eqn{j}th subject of the
\eqn{i}th treatment sequence, \eqn{\gamma_k} is the period effect,
and \eqn{e_{ijk}} is the random error with variance \eqn{\sigma^2}
for the subject in period \eqn{k}. The direct effect of the treatment
administered in period \eqn{k} of sequence \eqn{i} is
\eqn{\tau_{d(i,k)}}, and \eqn{\lambda_{c(i,k-1)}} is the carryover
effect of the treatment administered in period \eqn{k-1} of sequence
\eqn{i}. The value of the carryover effect for the observed
response in the first period is \eqn{\lambda_{c(i,0)} = 0} since
there is no carryover effect in the first period. The intra-subject
correlation due to the subject random effect is
\deqn{\rho = \frac{\sigma_b^2}{\sigma_b^2 + \sigma^2}.}
Therefore, \code{stDev} = \eqn{\sigma^2} and \code{corr} = \eqn{\rho}.
By constructing the design matrix \eqn{X} for the linear model with
a compound symmetry covariance matrix for the response vector of
a subject, we can obtain \deqn{Var(\hat{\beta}) = (X'V^{-1}X)^{-1}.}

The covariance matrix for the direct treatment effects and
carryover treatment effects can be extracted from the appropriate
sub-matrices. The covariance matrix for the direct treatment effects
without accounting for the carryover treatment effects can be obtained
by omitting the carryover effect terms from the model.

The power is for the direct treatment effect for the treatment pair of
interest with or without accounting for carryover effects as determined
by the input parameter \code{carryover}. The relative efficiency is
for the direct treatment effect for the treatment pair of interest
accounting for carryover effects relative to that without accounting
for carryover effects.

The degrees of freedom for the t-test accounting for carryover effects
can be calculated as the total number of observations minus
the number of subjects minus \eqn{p-1} minus \eqn{2(t-1)}
to account for the subject effect, period effect, and direct and
carryover treatment effects. The degrees of freedom for the t-test
without accounting for carryover effects is equal to the total number
of observations minus the number of subjects minus \eqn{p-1} minus
\eqn{t-1} to account for the subject effect, period effect, and direct
treatment effects.
}
\examples{

# Williams design for 4 treatments

(design1 = getDesignMeanDiffCarryover(
  beta = 0.2, n = NA,
  meanDiff = 0.5, stDev = 1,
  design = matrix(c(1, 4, 2, 3,
                    2, 1, 3, 4,
                    3, 2, 4, 1,
                    4, 3, 1, 2),
                  4, 4, byrow = TRUE),
  alpha = 0.025))

}
\references{
Robert O. Kuehl. Design of Experiments: Statistical Principles of
Research Design and Analysis. Brooks/Cole: Pacific Grove, CA. 2000.
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
