% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{nbstat1}
\alias{nbstat1}
\title{Negative binomial rate ratio by stratum}
\usage{
nbstat1(
  time = NA_real_,
  rateRatioH0 = 1,
  allocationRatioPlanned = 1,
  accrualTime = 0L,
  accrualIntensity = NA_real_,
  piecewiseSurvivalTime = 0L,
  stratumFraction = 1L,
  kappa1 = NA_real_,
  kappa2 = NA_real_,
  lambda1 = NA_real_,
  lambda2 = NA_real_,
  gamma1 = 0L,
  gamma2 = 0L,
  accrualDuration = NA_real_,
  followupTime = NA_real_,
  fixedFollowup = 0L,
  nullVariance = 0L
)
}
\arguments{
\item{time}{The calendar time for data cut.}

\item{rateRatioH0}{Rate ratio under the null hypothesis.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{accrualTime}{A vector that specifies the starting time of
piecewise Poisson enrollment time intervals. Must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities. One for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{stratumFraction}{A vector of stratum fractions that sum to 1.
Defaults to 1 for no stratification.}

\item{kappa1}{The dispersion parameter (reciprocal of the shape
parameter of the gamma mixing distribution) for the active treatment
group by stratum.}

\item{kappa2}{The dispersion parameter (reciprocal of the shape
parameter of the gamma mixing distribution) for the control group by
stratum.}

\item{lambda1}{The rate parameter of the negative binomial distribution
for the active treatment group by stratum.}

\item{lambda2}{The rate parameter of the negative binomial distribution
for the control group by stratum.}

\item{gamma1}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the active treatment group.}

\item{gamma2}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the control group.}

\item{accrualDuration}{Duration of the enrollment period.}

\item{followupTime}{Follow-up time for the last enrolled subject.}

\item{fixedFollowup}{Whether a fixed follow-up design is used.
Defaults to 0 for variable follow-up.}

\item{nullVariance}{Whether to calculate the variance for log rate ratio
under the null hypothesis.}
}
\value{
A list with two components:
\itemize{
\item \code{resultsUnderH1}: A data frame containing the following variables:
\itemize{
\item \code{stratum}: The stratum.
\item \code{time}: The calendar time since trial start.
\item \code{subjects}: The number of enrolled subjects.
\item \code{nevents}: The total number of events.
\item \code{nevents1}: The number of events in the active treatment
group.
\item \code{nevents2}: The number of events in the control group.
\item \code{ndropouts}: The total number of dropouts.
\item \code{ndropouts1}: The number of dropouts in the active treatment
group.
\item \code{ndropouts2}: The number of dropouts in the control group.
\item \code{nfmax}: The total number of subjects reaching maximum
follow-up.
\item \code{nfmax1}: The number of subjects reaching maximum follow-up
in the active treatment group.
\item \code{nfmax2}: The number of subjects reaching maximum follow-up
in the control group.
\item \code{exposure}: The total exposure time.
\item \code{exposure1}: The exposure time for the active treatment group.
\item \code{exposure2}: The exposure time for the control group.
\item \code{rateRatio}: The rate ratio of the active treatment group
versus the control group.
\item \code{vlogRate1}: The variance for the log rate parameter for the
active treatment group.
\item \code{vlogRate2}: The variance for the log rate parameter for the
control group.
\item \code{vlogRR}: The variance of log rate ratio.
}
\item \code{resultsUnderH0} when \code{nullVariance = TRUE}: A data frame
with the following variables:
\itemize{
\item \code{stratum}: The stratum.
\item \code{time}: The analysis time since trial start.
\item \code{lambda1H0}: The restricted maximum likelihood estimate
of the event rate for the active treatment group.
\item \code{lambda2H0}: The restricted maximum likelihood estimate
of the event rate for the control group.
\item \code{rateRatioH0}: The rate ratio under H0.
\item \code{vlogRate1H0}: The variance for the log rate parameter for
the active treatment group under H0.
\item \code{vlogRate2H0}: The variance for the log rate parameter for
the control group under H0.
\item \code{vlogRRH0}: The variance of log rate ratio under H0.
\item \code{lambda1}: The true event rate for the active treatment group.
\item \code{lambda2}: The true event rate for the control group.
\item \code{rateRatio}: The true rate ratio.
}
\item \code{resultsUnderH0} when \code{nullVariance = FALSE}: A data frame
with the following variables:
\itemize{
\item \code{stratum}: The stratum.
\item \code{time}: The analysis time since trial start.
\item \code{rateRatioH0}: The rate ratio under H0.
\item \code{lambda1}: The true event rate for the active treatment group.
\item \code{lambda2}: The true event rate for the control group.
\item \code{rateRatio}: The true rate ratio.
}
}
}
\description{
Obtains the number of subjects accrued, number of events,
number of dropouts, number of subjects reaching the maximum
follow-up, total exposure, rate and variance for log rate in each group,
rate ratio and variance for log rate ratio by stratum at a given
calendar time.
}
\examples{
# Example 1: Variable follow-up design

nbstat1(time = 2,
       accrualIntensity = 1956/1.25,
       kappa1 = 5,
       kappa2 = 5,
       lambda1 = 0.7*0.125,
       lambda2 = 0.125,
       gamma1 = 0,
       gamma2 = 0,
       accrualDuration = 1.25,
       followupTime = 2.75)

# Example 2: Fixed follow-up design

nbstat1(time = 1.8,
       accrualIntensity = 220/1.5,
       stratumFraction = c(0.2, 0.8),
       kappa1 = 3,
       kappa2 = 3,
       lambda1 = c(0.5*8.4, 0.7*10.2),
       lambda2 = c(8.4, 10.2),
       gamma1 = 0.05,
       gamma2 = 0.05,
       accrualDuration = 1.5,
       followupTime = 0.5,
       fixedFollowup = 1,
       nullVariance = 1)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
\keyword{internal}
