% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/periods.r
\name{period}
\alias{is.period}
\alias{period}
\title{Create a period object.}
\usage{
period(num = NULL, units = "second", ...)

is.period(x)
}
\arguments{
\item{num}{a numeric vector that lists the number of time units to be included in the period}

\item{units}{a character vector that lists the type of units to be used. The units in units 
are matched to the values in num according to their order.}

\item{...}{a list of time units to be included in the period and their
amounts. Seconds, minutes,  hours, days, weeks, months, and years are
supported. Normally only one of \code{num} or \code{...} are present. If
both are present, the periods are concatenated.}

\item{x}{an R object}
}
\value{
a period object
}
\description{
\code{period} creates a period object with the specified values. period
provides the behaviour of \code{\link{period}} in a way that is more
suitable for automating within a function.
}
\details{
Within a Period object, time units do not have a fixed length (except for
seconds) until they are added to a date-time. The length of each time unit
will depend on the date-time to which it is added. For example, a year that
begins on 2009-01-01 will be 365 days long.  A year that begins on 2012-01-01
will be 366 days long. When math is performed with a period object, each unit
is applied separately. How the length of a period is distributed among its
units is non-trivial. For example, when leap seconds occur 1 minute is longer
than 60 seconds.

Periods track the change in the "clock time" between two date-times. They 
are measured in common time related units: years, months, days, hours, 
minutes, and seconds. Each unit except for seconds must be expressed in 
integer values.

Period objects can be easily created with the helper functions 
\code{\link{years}}, \code{\link{months}}, \code{\link{weeks}}, 
\code{\link{days}}, \code{\link{hours}}, \code{\link{minutes}}, 
and \code{\link{seconds}}. These objects can be added to and subtracted 
to date-times to create a user interface similar to object oriented programming.
}
\examples{
period(c(90, 5), c("second", "minute"))
#  "5M 90S"
period(-1, "days")
# "-1d 0H 0M 0S"
period(c(3, 1, 2, 13, 1), c("second", "minute", "hour", "day", "week"))
# "20d 2H 1M 3S"
period(c(1, -60), c("hour", "minute"))
# "1H -60M 0S"
period(0, "second")
# "0S"
period (second = 90, minute = 5)
# "5M 90S"
period(day = -1)
# "-1d 0H 0M 0S"
period(second = 3, minute = 1, hour = 2, day = 13, week = 1)
# "20d 2H 1M 3S"
period(hour = 1, minute = -60)
# "1H -60M 0S"
period(second = 0)
# "0S"
period(c(1, -60), c("hour", "minute"), hour = c(1, 2), minute = c(3, 4))
# "1H -60M 0S" "1H 3M 0S"   "2H 4M 0S"  
is.period(as.Date("2009-08-03")) # FALSE
is.period(period(months= 1, days = 15)) # TRUE
}
\keyword{chron}
\keyword{classes}

