% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{loglikC_bin}
\alias{loglikC_bin}
\alias{loglikC_bin_wDates}
\alias{loglikratioC_diff_arbitrary}
\title{C++ implementation of the pseudo-likelihood computation}
\usage{
loglikC_bin(Bmat, Amat, eps_p, eps_n, piA, piB)

loglikC_bin_wDates(Bmat, Amat, Bdates, Adates, eps_p, eps_n, piA, piB)

loglikratioC_diff_arbitrary(Bmat, Amat, d_max, cost)
}
\arguments{
\item{Bmat}{\code{K x nB} matrix of the observations to be matched.}

\item{Amat}{\code{nA x K} matrix the database into which a match is looked for.}

\item{eps_p}{a vector of length \code{K} giving the prior discrepancy rate 
expected from A to B for the positives, for each variable.}

\item{eps_n}{a vector of length \code{K} giving the prior discrepancy rate 
expected from A to B for the negatives, for each variable.}

\item{piA}{a vector of length \code{K} giving the prior probabilities of 
observing each variable in A.}

\item{piB}{a vector of length \code{K} giving the prior probabilities of 
observing each variable in B.}

\item{Bdates}{\code{nB x K} matrix of the dates for each observations to be matched.}

\item{Adates}{\code{nA x K} matrix of the dates for database into which a match is looked for.}

\item{d_max}{a numeric vector of length \code{K} giving the minimum difference 
from which it is considered a discrepency.}

\item{cost}{a numeric vector of length \code{K} giving the arbitrary cost of discrepency.}
}
\description{
\code{loglikC_bin} implements an even faster C++ implementation of the pseudo-likelihood computation for binary
variables

\code{loglikC_bin_wDates} implements a C++ implementation of the pseudo-likelihood computation for binary
variables with dates

Fast C++ implementation of the log-likelihood ratio computation for 
differentiating variables
}

