% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/compareAUC.R
\docType{methods}
\name{compareAUC}
\alias{compareAUC}
\alias{compareAUC,PredictionList-method}
\alias{compareAUC,list-method}
\title{Calculate the area under the ROC curve (AUC)}
\usage{
compareAUC(pred, ...)

\S4method{compareAUC}{PredictionList}(pred, digits = 4, ...)

\S4method{compareAUC}{list}(pred, digits = 4, ...)
}
\arguments{
\item{pred}{a PredictionList object or a list of these}

\item{digits}{numeric indicating the number of digits to be displayed after
the decimal point for AUC values}

\item{\dots}{additional arguments (none)}
}
\value{
A data.frame.
}
\description{
Estimate the AUC for each \code{ROCR::\link[ROCR]{prediction}} object in a
\code{\link{PredictionList}} object.
}
\details{
The user can compare the performance of different statistical models by
providing a list of \code{PredictionList} objects. Note that \code{compareAUC}
should be used in conjunction with other comparison methods because the AUC
does not contain as much information as, for instance, the ROC curve itself
(Pontius and Parmentier, 2014).
}
\examples{
## see PredictiveModelList examples
}
\references{
Sing, T., Sander, O., Beerenwinkel, N., Lengauer, T. (2005). ROCR: visualizing
classifier performance in R. Bioinformatics 21(20):3940-3941.

Pontius Jr, R. G., & Parmentier, B. (2014). Recommendations for using the
relative operating characteristic (ROC). Landscape ecology, 29(3), 367-382.
}
\seealso{
\code{\link{PredictionList}}, \code{ROCR::\link[ROCR]{performance}}
}

