% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/performance.rocr.R
\docType{methods}
\name{performance}
\alias{performance}
\alias{performance,list-method}
\title{Create ROCR performance objects}
\usage{
performance(prediction.obj, ...)

\S4method{performance}{list}(prediction.obj, measure, x.measure = "cutoff",
  ...)
}
\arguments{
\item{prediction.obj}{a list of \code{ROCR::\link[ROCR]{prediction}} objects}

\item{measure}{performance measure to use for the evaluation. See
\code{ROCR::\link[ROCR]{performance}}}

\item{x.measure}{a second performance measure. See
\code{ROCR::\link[ROCR]{performance}}}

\item{\dots}{additional arguments to \code{ROCR::\link[ROCR]{performance}}}
}
\value{
A list of \code{performance} objects.
}
\description{
A wrapper function for \code{ROCR::\link[ROCR]{performance}} (Sing et al,
2005) to create \code{performance} objects from a list of \code{prediction}
objects.
}
\references{
Sing, T., Sander, O., Beerenwinkel, N., Lengauer, T. (2005).
ROCR: visualizing classifier performance in R. Bioinformatics
21(20):3940-3941.
}
\seealso{
\code{ROCR::\link[ROCR]{prediction}},
\code{ROCR::\link[ROCR]{performance}}
}

