% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module.R
\name{predict.luz_module_fitted}
\alias{predict.luz_module_fitted}
\title{Create predictions for a fitted model}
\usage{
\method{predict}{luz_module_fitted}(
  object,
  newdata,
  ...,
  callbacks = list(),
  accelerator = NULL,
  verbose = NULL,
  dataloader_options = NULL
)
}
\arguments{
\item{object}{(fitted model) the fitted model object returned from \code{\link[=fit.luz_module_generator]{fit.luz_module_generator()}}}

\item{newdata}{(dataloader, dataset, list or array) returning a list with at
least 1 element. The other elements aren't used.}

\item{...}{Currently unused.}

\item{callbacks}{(list, optional) A list of callbacks defined with
\code{\link[=luz_callback]{luz_callback()}} that will be called during the training procedure. The
callbacks \code{\link[=luz_callback_metrics]{luz_callback_metrics()}}, \code{\link[=luz_callback_progress]{luz_callback_progress()}} and
\code{\link[=luz_callback_train_valid]{luz_callback_train_valid()}} are always added by default.}

\item{accelerator}{(accelerator, optional) An optional \code{\link[=accelerator]{accelerator()}} object
used to configure device placement of the components like \link[torch:nn_module]{torch::nn_module}s,
optimizers and batches of data.}

\item{verbose}{(logical, optional) An optional boolean value indicating if
the fitting procedure should emit output to the console during training.
By default, it will produce output if \code{\link[=interactive]{interactive()}} is \code{TRUE}, otherwise
it won't print to the console.}

\item{dataloader_options}{Options used when creating a dataloader. See
\code{\link[torch:dataloader]{torch::dataloader()}}. \code{shuffle=TRUE} by default for the training data and
\code{batch_size=32} by default. It will error if not \code{NULL} and \code{data} is
already a dataloader.}
}
\description{
Create predictions for a fitted model
}
\seealso{
Other training: 
\code{\link{evaluate}()},
\code{\link{fit.luz_module_generator}()},
\code{\link{setup}()}
}
\concept{training}
