% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcts_used_for_ind_comp.R
\name{dist.point}
\alias{dist.point}
\title{Compute distances of all points to a given point in the functional space}
\usage{
dist.point(sp_faxes_coord, ref_sp)
}
\arguments{
\item{sp_faxes_coord}{a matrix of species coordinates in a chosen functional
space. Species coordinates have been retrieved thanks to
\code{\link{tr.cont.fspace}} or \code{\link{quality.fspaces}}.}

\item{ref_sp}{a character string referring to the name of the reference
species.}
}
\value{
A vector of species distances to the reference species.
}
\description{
This function computes the distances of all species to a reference species.
It is used in FSpe, FOri and FNND computation.
}
\examples{
# Load Species*Traits dataframe:
 data("fruits_traits", package = "mFD")

# Load Assemblages*Species dataframe:      
 data("baskets_fruits_weights", package = "mFD") 

# Load Traits categories dataframe:
 data("fruits_traits_cat", package = "mFD") 
 
# Compute functional distance 
 sp_dist_fruits <- mFD::funct.dist(sp_tr         = fruits_traits,
                                   tr_cat        = fruits_traits_cat,
                                   metric        = "gower",
                                   scale_euclid  = "scale_center",
                                   ordinal_var   = "classic",
                                   weight_type   = "equal",
                                   stop_if_NA    = TRUE)
  
# Compute functional spaces quality to retrieve species coordinates matrix:
 fspaces_quality_fruits <- mFD::quality.fspaces(
                                  sp_dist             = sp_dist_fruits, 
                                  maxdim_pcoa         = 10,
                                  deviation_weighting = "absolute",
                                  fdist_scaling       = FALSE,
                                  fdendro             = "average")
 
# Retrieve species coordinates matrix:
 sp_faxes_coord_fruits <- fspaces_quality_fruits$details_fspaces$sp_pc_coord

# Retrieve the distances of all species to "pear":
 dist_pear <- dist.point(sp_faxes_coord_fruits, ref_sp = "pear")
 dist_pear
}
\author{
Camille Magneville and Sebastien Villeger
}
