% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obtain_gamma.R
\name{obtain_gamma}
\alias{obtain_gamma}
\title{Obtain the transition probabilities gamma for a fitted multilevel HMM}
\usage{
obtain_gamma(object, level = "group", burn_in = NULL)
}
\arguments{
\item{object}{An object of class \code{mHMM}, generated
by the function \code{\link{mHMM}}.}

\item{level}{String specifying if the returned transition probability matrix
gamma should be at the group level (\code{level = "group"}), i.e.,
representing the average transition probability matrix over all subjects,
or at the subject level (\code{level = "subject"}).}

\item{burn_in}{An integer which specifies the number of iterations to discard
when obtaining the model parameter summary statistics. When left
unspecified (\code{burn_in = NULL}), the burn in period specified when
creating the \code{mHMM} object will be used.}
}
\value{
\code{obtain_gamma} returns the object \code{est_gamma} of the class
  \code{mHMM_gamma}. This object can be directly plotted using the function
  \code{plot.mHMM_gamma()}, or simply \code{plot()}. Depending on the
  specification at the input variable \code{level}, \code{est_gamma} is
  either a matrix with the transition probabilities at the group level (if
  \code{level = "group"}), or a list of matrices (with the number of elements
  equal to the number of subjects analyzed, if \code{level = 'subject'}),
  where each matrix in the list represents a subject specific transition
  probability matrix.
}
\description{
\code{obtain_gamma} obtains the transition probability matrix for a
fitted multilevel hidden Markov model, for either the group level, i.e.,
  representing the average transition probability matrix over all subjects,
  or at the subject level, returning the transition probability matrices for
  each subject.
}
\examples{
###### Example on package data, see ?nonverbal
\donttest{
# specifying general model properties:
m <- 2
n_dep <- 4
q_emiss <- c(3, 2, 3, 2)

# specifying starting values
start_TM <- diag(.8, m)
start_TM[lower.tri(start_TM) | upper.tri(start_TM)] <- .2
start_EM <- list(matrix(c(0.05, 0.90, 0.05,
                          0.90, 0.05, 0.05), byrow = TRUE,
                        nrow = m, ncol = q_emiss[1]), # vocalizing patient
                 matrix(c(0.1, 0.9,
                          0.1, 0.9), byrow = TRUE, nrow = m,
                        ncol = q_emiss[2]), # looking patient
                 matrix(c(0.90, 0.05, 0.05,
                          0.05, 0.90, 0.05), byrow = TRUE,
                        nrow = m, ncol = q_emiss[3]), # vocalizing therapist
                 matrix(c(0.1, 0.9,
                          0.1, 0.9), byrow = TRUE, nrow = m,
                        ncol = q_emiss[4])) # looking therapist

# Run a model without covariate(s):
out_2st <- mHMM(s_data = nonverbal,
                gen = list(m = m, n_dep = n_dep, q_emiss = q_emiss),
                start_val = c(list(start_TM), start_EM),
                mcmc = list(J = 11, burn_in = 5))

out_2st
summary(out_2st)

# obtaining the transition probabilities at the group and subject level
obtain_gamma(out_2st, level = "group")
obtain_gamma(out_2st, level = "subject")

}

}
\seealso{
\code{\link{mHMM}} for fitting the multilevel hidden Markov model,
  and \code{\link{plot.mHMM_gamma}} for plotting the obtained transition
  probabilities.
}
