% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module4_data_imputation.R
\name{data.imputation}
\alias{data.imputation}
\title{Data imputation for the cleaned data with annotation}
\usage{
data.imputation(workdir, csvInput)
}
\arguments{
\item{workdir}{\code{character} Directory where the output needs to be stored. Note that this directory must exist.}

\item{csvInput}{\code{character} File name with or without directory for sample information in CSV format. The ENMO data will be read through read.csv(csvInput,header=1) command, and the missing values were imputated by the average ENMO over all the valid days for each subject at each time point. In this package, csvInput =  flag_All_studyname_ENMO.data.Xs.csv.}
}
\value{
Files were written to the specified sub-directory, named as impu.flag_All_studyname_ENMO.data.Xs.csv, which Xs is the epoch size to which acceleration was averaged (seconds) in GGIR output.  This excel file includs the following columns,
\item{          filename}{accelerometer file name } 
\item{          Date}{date recored from the GGIR part2.summary file }
\item{          id}{IDs recored from the GGIR part2.summary file }
\item{          calender_date}{date in the format of yyyy-mm-dd }
\item{          N.valid.hours}{number of hours with valid data recored from the part2_daysummary.csv file in the GGIR output }
\item{          N.hours}{number of hours of measurement recored from the part2_daysummary.csv file in the GGIR output }
\item{          weekday}{day of the week-Day of the week }
\item{          measurementday}{day of measurement-Day number relative to start of the measurement }
\item{          newID}{new IDs defined as the user-defined function of filename2id(), e.g. substrings of the filename } 
\item{          Nmiss_c9_c31}{number of NAs from the 9th to 31th column in the part2_daysummary.csv file in the GGIR output} 
\item{          missing}{"M" indicates missing for an invalid day, and  "C" indicates completeness for a valid day }
\item{          Ndays}{number of days of measurement  }
\item{          ith_day}{rank of the measurementday, for example, the value is 1,2,3,4,-3,-2,-1 for measurementday = 1,...,7 }
\item{          Nmiss}{number of missing (invalid) days  }
\item{          Nnonmiss}{number of non-missing (valid) days } 
\item{          misspattern}{indicators of missing/nonmissing for all measurement days at the subject level }
\item{          RowNonWear}{number of columnns in the non-wearing matrix }
\item{          NonWearMin}{number of minutes of non-wearing}
\item{          daysleeper}{If 0 then the person is a nightsleeper (sleep period did not overlap with noon) if value=1 then the person is a daysleeper (sleep period did overlap with noon).}  	
\item{          remove16h7day}{indicator of a key qulity control output. If remove16h7day=1, the day need to be removed. If remove16h7day=0, the day need to be kept.}   
\item{          duplicate}{If duplicate="remove",  the accelerometer files will not be used in the data analysis of module5.} 
\item{          ImpuMiss.b}{number of missing values on the ENMO data before imputation}	
\item{          ImpuMiss.a}{number of missing values on the ENMO data after imputation}		
\item{          KEEP}{The value is "keep"/"remove", e.g. KEEP="remove" if remove16h7day=1 or duplicate="remove" or ImpuMiss.a>0}
}
\description{
Data imputation for the merged ENMO data with annotation. The missing values were imputated by the average ENMO over all the valid days for each subject.
}
