% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom-search.R
\name{custom_search}
\alias{custom_search}
\title{Custom Search}
\usage{
custom_search(imapconf, custom_request, negate = FALSE, by = "MSN",
  esearch = FALSE, return_imapconf = TRUE, retries = 2)
}
\arguments{
\item{imapconf}{An object of class \code{imapconf} generated with
\link{configure_imap} and with a \code{mbox} item added after a
mailbox selection with \link{select_mailbox}.}

\item{custom_request}{A string directly specifying what to search or
constructed by a combination of operators helper functions \link{OR} and
\link{AND}, and criteria helper functions such as \link{before}, \link{since},
\link{on}, \link{sent_before}, \link{sent_since}, \link{sent_on},
\link{flag}, \link{string}, \link{smaller_than}, \link{larger_than},
\link{younger_than}, or \link{younger_than}.}

\item{negate}{If \code{TRUE}, negates the search and seeks for
"NOT search_criterion". Default is \code{FALSE}.}

\item{by}{Which id (\code{MSN} or \code{UID}) to use when searching for
messages. \code{"MSN"} or message squence number is a message's relative
position to the older message in the mailbox. It may change after deleting
or moving messages. For instance, if a message is deleted, message sequence
numbers are reordered to fill the gap. \code{"UID"} or unique identifier
is always the same during the life cycle of a message. Default is
\code{"MSN"}.}

\item{esearch}{A logical. Default is \code{FALSE}. If the IMAP server has
\code{ESEARCH} capability, it can be used to optimize search results. It
allows to condense results to message sets to cut down on transmission
costs, e.g. \code{1:5} instead of writing ids individually such as
code{1,2,3,4,5}. It can be used along with buffersize to avoid results
stripping. Check if your IMAP server supports \code{SEARCH} with
\code{\link{list_server_capabilities}}.}

\item{return_imapconf}{A logical. If \code{TRUE}, the function returns a
\code{list} of length \code{2}, containing the \code{imapconf} object
(IMAP settings) and the search results as message ids (\code{"MSN"} or
\code{"UID"}). If \code{FALSE}, returns only the message ids as a numeric
vector. Default is \code{TRUE}.}

\item{retries}{Number of attempts to connect and execute the command. Default
is \code{2}.}
}
\value{
Depending on the \code{return_imapconf} parameter, it can be a
    \code{list} of length \code{2} containing the \code{imapconf} object
    and message ids resulted from search, or a numeric vector containing
    only message ids.
}
\description{
Allows a combination of several arguments using helper functions
    that serve as relational operators, such as \link{OR} and \link{AND}; and
    criteria helper functions such as \link{before}, \link{since},
    \link{on}, \link{sent_before}, \link{sent_since}, \link{sent_on},
    \link{flag}, \link{string}, \link{smaller_than}, \link{larger_than},
    \link{younger_than}, or \link{younger_than}, in order to execute a
    custom search (with multiple arguments).
}
\note{
IMAP queries follows Polish notation, i.e. operators such as \code{OR}
    come before arguments, e.g. "OR argument1 argument2". Therefore, the
    relational operators functions in this package should be used like the
    following examples: \code{OR(before("17-Apr-2015"), string("FROM", "Jim"))}.
    Even though there is no "AND" operator in IMAP, this package adds a helper
    funcion \link{AND} to indicate multiples arguments that must be searched
    together, e.g. \code{AND(since("01-Jul-2018"), smaller_than(16000))}.
}
\examples{

\dontrun{

# configure IMAP
library(mRpostman)
imapconf <- configure_imap(url="imaps://imap.gmail.com",
                           username="your_gmail_user",
                           password=rstudioapi::askForPassword()
                          )
# search1
result1 <- imapconf \%>\%
    select_mailbox(mbox = "TAM") \%>\%
    custom_search(custom_request = AND(string(section_or_field = "TO",
                                              string = "allan"),
                                       before(date_char = "12-Apr-2009")
                                      ))
# searches for messages containing the string "allan" in the "TO" field
# and that were received before "12-Apr-2009".

# search2
result2 <- imapconf \%>\%
    select_mailbox(mbox = "INBOX") \%>\%
    custom_search(custom_request = OR(string(section_or_field = "TEXT",
                                             string = "Contract 2872827"),
                                      string(section_or_field = "Subject",
                                             string = "Buying operation")
                                             ))
# searches for messages containing the string "Contract 2872827" in the
# "TEXT" section or the string "Buying operation" in the "Subject" field
# of the HEADER.

}

}
\seealso{
Other Date-search operations: \code{\link{search_before}},
  \code{\link{search_on}}, \code{\link{search_period}},
  \code{\link{search_sent_before}},
  \code{\link{search_sent_on}},
  \code{\link{search_sent_period}},
  \code{\link{search_sent_since}},
  \code{\link{search_since}}

Other Size-search operations: \code{\link{search_larger_than}},
  \code{\link{search_smaller_than}}

Other Flag-search operations: \code{\link{search_flag}}

Other Within-search operations: \code{\link{search_older_than}},
  \code{\link{search_younger_than}}
}
\concept{Custom-search operations}
\concept{Date-search operations}
\concept{Flag-search operations}
\concept{Size-search operations}
\concept{String-search operations}
\concept{Within-search operations}
