% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicates.R
\name{duplicates}
\alias{duplicates}
\title{Report and tag duplicated observations}
\usage{
duplicates(data, ..., drop = FALSE)
}
\arguments{
\item{data}{Dataset}

\item{...}{Variables to find duplications.}

\item{drop}{if \code{TRUE}, delete all duplicated records, keeping all unique.
If not specified, all variables are used.}
}
\value{
Modified dataset with additional variable \code{dup}
}
\description{
\code{duplicates()} reports duplications and creates indexes.
}
\details{
Specified variables are used to search for duplications. If not
specified, all variables are used.

Then they are pasted as a character vector for speedy operation,
extract duplication data and make a report.

The return dataset is added a new variable called \code{dup}
for further use.

\strong{ANNOTATIONS}:

\code{Copies}       - nth Copies

\code{Observations} - Number of corresponding observations

\code{Surplus}  - Number of surplus observations

\code{dup} - indicates copies within the dataset:

0 = unique observations

2 = duplicated two times

3 = duplicated three times and so on ...
}
\examples{

## use infert data
data(infert)
codebook(infert)

## find duplicates by pooled.stratum
duplicates(infert, pooled.stratum)

## find duplicates by stratum and pooled.stratum
duplicates(infert, stratum, pooled.stratum)

## find and remove duplicates by pooled.stratum
duplicates(infert, pooled.stratum, drop = TRUE)

}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
