% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{macleish_layers}
\alias{macleish_layers}
\title{MacLeish spatial data}
\format{A \code{list} of \code{\link[sp]{Spatial}} objects, each providing a different layer.

\describe{
 \item{landmarks}{Landmarks}
 \item{forests}{Type of dominant tree in individual forests, as 
 noted by Jesse Bellemare}
 \item{streams}{local streams}
 \item{challenge_courses}{Challenge courses on the property}
 \item{reservoir}{a reservoir}
 \item{buildings}{Buildings at MacLeish}
 \item{wetlands}{Wetland areas}
 \item{trails}{Hiking trails}
 \item{schools}{Schools in Massachusetts}
 \item{boundary}{the property boundary}
 \item{research}{research plots}
 \item{soil}{soil deposits used by Amy Rhodes}
}}
\usage{
macleish_layers
}
\description{
Shapefiles from the MacLeish Field Station. The field station
itself is located at \code{lat = 42.449167}, \code{lon = -72.679389}. These
data contains information about various man-made and natural structures
surrounding the field station.
}
\details{
Each of the \code{\link[sp]{Spatial}} objects are projected in 
\code{epsg:4326} for easy integration with \code{\link[ggmap]{ggmap}} or
\code{\link[leaflet]{leaflet}} objects.
}
\examples{
names(macleish_layers)
summary(macleish_layers[["buildings"]])

if (require(sp)) {
 plot(macleish_layers[["buildings"]])
}

}
\keyword{datasets}
