% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.madr.enumerate.r
\name{summary.madr.enumerate}
\alias{summary.madr.enumerate}
\title{Provides model averaged double robust estimate for different values of tau}
\usage{
\method{summary}{madr.enumerate}(object, tau = NULL, two.stage = NULL, ...)
}
\arguments{
\item{object}{madr.enumerate object}

\item{tau}{scalar value for the prior model dependence (1 is an independent prior; defaults to value used in madr.enumerate)}

\item{two.stage}{indicator if the two-stage procedure for calculating the model weights should be used (defaults to value used in madr.enumerate)}

\item{...}{ignored}
}
\value{
A list. The list contains the following named components:
\item{madr}{the model averaged double robust estimate}
\item{weight.ps}{a vector that contains the inclusion probability of each covariate in the propensity score model}
\item{weight.om}{a vector that contains the inclusion probability of each covariate in the outcome model}
\item{tau}{value of tau used in estimation}
\item{two.stage}{indicator if the two-stage procedure for calculating the model weights was used}
}
\description{
This function estimates model averaged double robust estimate for different values of tau using a madr.enumerate object
}

