% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setConfig.R
\name{setConfig}
\alias{setConfig}
\title{setConfig}
\usage{
setConfig(
  regionmapping = NULL,
  packages = NULL,
  globalenv = NULL,
  enablecache = NULL,
  verbosity = NULL,
  mainfolder = NULL,
  sourcefolder = NULL,
  cachefolder = NULL,
  mappingfolder = NULL,
  outputfolder = NULL,
  pop_threshold = NULL,
  forcecache = NULL,
  ignorecache = NULL,
  delete_cache = NULL,
  diagnostics = NULL,
  nocores = NULL,
  debug = NULL,
  .cfgchecks = TRUE,
  .verbose = TRUE
)
}
\arguments{
\item{regionmapping}{The name of the csv file containing the region mapping
that should be used for aggregation (e.g. "regionmappingREMIND.csv").}

\item{packages}{A character vector with packages in which corresponding 
read and calc functions should be searched for}

\item{globalenv}{Boolean deciding whether sources/calculations in the global 
environment should be included or not}

\item{enablecache}{Boolean deciding whether data should be read from cache
if data is available and the up-to-date (data will always be written to the
cache regardless of this setting)}

\item{verbosity}{an integer value describing the verbosity of the functions
(2 = full information, 1 = only warnings and execution information, 0 = only
warnings, -1 = no information)}

\item{mainfolder}{The mainfolder where all data can be found and should be
written to.}

\item{sourcefolder}{The folder in which all source data is stored (in
sub-folders with the name of the source as folder name). In the default case
this argument is set to NA meaning that the default folder should be used
which is <mainfolder>/sources}

\item{cachefolder}{The folder in which all cache files should be written to.
In the default case this argument is set to NA meaning that the default
folder should be used which is <mainfolder>/cache}

\item{mappingfolder}{A folder containing all kinds of mappings (spatial,
temporal or sectoral). In the default case this argument is set to NA
meaning that the default folder should be used which is
<mainfolder>/mappings}

\item{outputfolder}{The folder all outputs should be written to. In the
default case this argument is set to NA meaning that the default folder
should be used which is <mainfolder>/output}

\item{pop_threshold}{Population threshold in capita which determines whether
the country is put into the "important" or "dispensable" class in
\code{\link{getISOlist}}. This distinction is used for different treatment
of countries in notifications to set a focus on rather critical issues
instead of flooding the user with information.}

\item{forcecache}{Argument that allows to force madrat to read data from
cache if the corresponding cache files exist. It is either a boolean to
fully activate or deactivate the forcing or a vector of files (e.g. readTau, calcTauTotal) 
or type (e.g. Tau, TauTotal) that should be read from cache in any case.}

\item{ignorecache}{Argument that allows madrat to ignore the forcecache argument for the
given vector of files (e.g. readTau, calcTauTotal) or types 
(e.g. Tau, TauTotal) called by calcOutput or readSource.
The top level function must always be part of this list.}

\item{delete_cache}{Boolean deciding whether a temporary cache folder (as
created by retrieveInput) should be deleted after completion or not.}

\item{diagnostics}{file name for additional diagnostics information (without file ending).
3 diagnostic files will be written if a file name is provided (a csv showing the network 
of function executions, a log file showing the log and a full log showing the full amount
of available information.)}

\item{nocores}{integer number of cores to use for \code{\link[parallel]{clusterApply}} calls}

\item{debug}{Boolean which activates a debug mode. In debug mode all calculations will
be executed with try=TRUE so that calculations do not stop even if the previous calculation failed.
This can be helpful to get a full picture of errors rather than only seeing the first one. In addition
debug=TRUE will add the suffix "debug" to the files created to avoid there use in productive runs.
Furthermore, with debug=TRUE calculations will be rerun even if a corresponding tgz file 
already exists.}

\item{.cfgchecks}{boolean deciding whether the given inputs to setConfig should be checked for
consistency or just be accepted (latter is only necessary in very rare cases and should not be used
in regular cases)}

\item{.verbose}{boolean deciding whether status information/updates should be shown or not}
}
\description{
This function manipulates the current madrat configuration. 
In general, NULL means that the argument remains as it is whereas
all other inputs will overwrite the current setting.
}
\examples{

 \dontrun{
   setConfig(forcecache=c("readSSPall","convertSSPall"))  
 }
}
\seealso{
\code{\link{getConfig}}, \code{\link{getISOlist}}
}
\author{
Jan Philipp Dietrich
}
