% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cacheName.R
\name{cacheName}
\alias{cacheName}
\title{Tool: cacheName}
\usage{
cacheName(
  prefix,
  type,
  args = NULL,
  graph = NULL,
  mode = "put",
  packages = getConfig("packages"),
  globalenv = getConfig("globalenv")
)
}
\arguments{
\item{prefix}{function prefix (e.g. "calc" or "read")}

\item{type}{output type (e.g. "TauTotal")}

\item{args}{a list of named arguments used to call the given function}

\item{graph}{A madrat graph as returned by \code{\link{getMadratGraph}}. 
Will be created with \code{\link{getMadratGraph}} if not provided.}

\item{mode}{Context in which the function is used. Either "get" (loading) or 
"put" (writing). In case of "put" the potential file name is returned. 
When set to "get", a file name will only be returned if the file exists 
(otherwise NULL) and in combination which \code{setConfig(forcecache=TRUE)} 
even a cache file with deviating hash might get selected.}

\item{packages}{A character vector with packages for which the available 
Sources/Calculations should be returned}

\item{globalenv}{Boolean deciding whether sources/calculations in the global 
environment should be included or not}
}
\value{
cached data, if cache is available, otherwise NULL
}
\description{
Load fitting cache data (if available)
}
\note{
\code{setConfig(forcecache=TRUE)} strongly affects the behavior
of \code{cacheName}. In read model it will also return cache names
with deviating hashes if no fitting cache file is found (in that case
it will just return the newest one). In write mode the hash in the name
will be left out since due to cache forcing it cannot be guaranteed
that the cache file agrees with the state represented by the hash.
}
\examples{
madrat:::cacheName("calc","TauTotal")
}
\seealso{
\code{\link{cachePut}}, \code{\link{cacheName}}
}
\author{
Jan Philipp Dietrich
}
