% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCalculations.R
\name{getCalculations}
\alias{getCalculations}
\title{getCalculations}
\usage{
getCalculations(
  prefix = "calc",
  packages = getConfig("packages"),
  globalenv = getConfig("globalenv")
)
}
\arguments{
\item{prefix}{Type of calculations, vector of types or search term (e.g. "read|calc"). Available options are
"download" (source download), "read" (source read), "correct" (source corrections),
"convert" (source conversion to ISO countries), "calc" (further calculations),
and "full" (collections of calculations)}

\item{packages}{A character vector with packages for which the available Sources/Calculations should be returned}

\item{globalenv}{Boolean deciding whether sources/calculations in the global environment should be included or not}
}
\value{
A data frame containing all currently available outputs of
all loaded data processing packages including its name, its function call and its package origin.
}
\description{
This function can be used to retrieve a list of currently available
sources and outputs (based on the availability of corresponding conversion
functions in the loaded data data processing packages.)
}
\examples{

print(getCalculations())
print(getCalculations("read"))

}
\seealso{
\code{\link{readSource}}, \code{\link{setConfig}}
}
\author{
Jan Philipp Dietrich
}
