% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latest_getters.R
\name{last_run_messages}
\alias{last_run_messages}
\title{Retrieve latest maestro pipeline messages}
\usage{
last_run_messages()
}
\value{
messages
}
\description{
Gets the latest pipeline messages following use of \code{run_schedule()}. If
there are no messages or \code{run_schedule()} has not been run it will be \code{NULL}.
}
\details{
Note that setting \code{maestroLogLevel} to something greater than \code{INFO} will
ignore messages.
}
\examples{
pipeline_dir <- tempdir()
create_pipeline("my_new_pipeline", pipeline_dir, open = FALSE, overwrite = TRUE)
schedule <- build_schedule(pipeline_dir = pipeline_dir)
run_schedule(schedule)
last_run_messages()
}
