% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latest_getters.R
\name{last_run_warnings}
\alias{last_run_warnings}
\title{Retrieve latest maestro pipeline warnings}
\usage{
last_run_warnings()
}
\value{
warning messages
}
\description{
Gets the latest pipeline warnings following use of \code{run_schedule()}. If
there are no warnings or \code{run_schedule()} has not been run it will be \code{NULL}.
}
\details{
Note that setting \code{maestroLogLevel} to something greater than \code{WARN} will
ignore warnings.
}
\examples{
pipeline_dir <- tempdir()
create_pipeline("my_new_pipeline", pipeline_dir, open = FALSE, overwrite = TRUE)
schedule <- build_schedule(pipeline_dir = pipeline_dir)
run_schedule(schedule)
last_run_warnings()
}
