% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_network.R
\name{show_network}
\alias{show_network}
\title{Visualize the schedule as a DAG}
\usage{
show_network(schedule)
}
\arguments{
\item{schedule}{object of type MaestroSchedule created using \code{build_schedule()}}
}
\value{
DiagrammeR visualization
}
\description{
Create an interactive network visualization to show the dependency structure
of pipelines in the schedule. This is only useful if there are pipelines in
the schedule that take inputs/outputs from other pipelines.
}
\details{
Note that running this function on a schedule with all independent pipelines
will produce a network visual with no connections.

This function requires the installation of \code{DiagrammeR} which is not automatically
installed with \code{maestro}.
}
\examples{
if (interactive()) {
  pipeline_dir <- tempdir()
  create_pipeline("my_new_pipeline", pipeline_dir, open = FALSE)
  schedule <- build_schedule(pipeline_dir = pipeline_dir)

  schedule <- run_schedule(
    schedule,
    orch_frequency = "1 day",
    quiet = TRUE
  )

  show_network(schedule)
}
}
