% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{FNdat}
\alias{FNdat}
\title{Dataset of noisy observations from the FitzHugh-Nagumo (FN) equations}
\format{
A data frame with 28 rows and 3 columns (time, \eqn{V}, \eqn{R}).
}
\usage{
data(FNdat)
}
\description{
The classic FN equations model the spike potentials of neurons, where system components \eqn{V} and \eqn{R} are the voltage and recovery variables, respectively.

\eqn{V} and \eqn{R} are governed by the following differential equations:

\deqn{ \frac{dV}{dt} = c(V-\frac{V^3}{3}+R) }
\deqn{ \frac{dR}{dt} = -\frac{1}{c}(V-a+bR) }

where \eqn{\theta = (a,b,c)} are system parameters.
This dataset was generated by first numerically solving these ODEs from \eqn{t=0} to \eqn{t=20}, with initial conditions \eqn{V(0) = -1} and \eqn{R(0) = 1} and parameters \eqn{\theta = (0.2, 0.2, 3)}.
The system components were taken to be measured at 28 observation time points (as indicated in \code{time} column) with additive Gaussian noise (standard deviation 0.2).
}
\references{
FitzHugh, R (1961). Impulses and Physiological States in Theoretical Models of Nerve Membrane. \emph{Biophysical Journal}, 1(6), 445–466.
}
\keyword{datasets}
