% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/video.R
\name{video}
\alias{video}
\alias{image_write_video}
\alias{image_write_gif}
\title{Write Video}
\usage{
image_write_video(image, path = NULL, framerate = 10, ...)

image_write_gif(image, path = NULL, delay = 1/10, ...)
}
\arguments{
\item{image}{magick image object returned by \code{\link[=image_read]{image_read()}} or \code{\link[=image_graph]{image_graph()}}}

\item{path}{filename of the output gif or video. This is also the return value.}

\item{framerate}{frames per second, passed to \link[av:av_encode_video]{av_encode_video}}

\item{...}{additional parameters passed to \link[av:av_encode_video]{av_encode_video} and
\link[gifski:gifski]{gifski}.}

\item{delay}{duration of each frame in seconds (inverse of framerate)}
}
\description{
High quality video / gif exporter based on external packages \link[gifski:gifski]{gifski}
and \link[av:av_encode_video]{av}.
}
\details{
This requires an image with multiple frames. The GIF exporter accomplishes the same
thing as \link{image_animate} but much faster and with better quality.
}
\seealso{
Other image: \code{\link{_index_}}, \code{\link{analysis}},
  \code{\link{animation}}, \code{\link{attributes}},
  \code{\link{color}}, \code{\link{composite}},
  \code{\link{device}}, \code{\link{edges}},
  \code{\link{editing}}, \code{\link{effects}},
  \code{\link{fx}}, \code{\link{geometry}},
  \code{\link{morphology}}, \code{\link{ocr}},
  \code{\link{options}}, \code{\link{painting}},
  \code{\link{segmentation}}, \code{\link{transform}}
}
\concept{image}
