% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2.R
\name{image_ggplot}
\alias{image_ggplot}
\title{Image to ggplot}
\usage{
image_ggplot(image, interpolate = FALSE)
}
\arguments{
\item{image}{magick image object returned by \code{\link[=image_read]{image_read()}} or \code{\link[=image_graph]{image_graph()}}}

\item{interpolate}{passed to \link[ggplot2:annotation_raster]{ggplot2::annotation_raster}}
}
\description{
Create a ggplot with axes set to pixel coordinates and plot the raster image
on it using \link[ggplot2:annotation_raster]{ggplot2::annotation_raster}. See examples for how to plot an image
onto an existing ggplot.
}
\examples{
# Plot with base R
plot(logo)

# Plot image with ggplot2
library(ggplot2)
myplot <- image_ggplot(logo)
myplot + ggtitle("Test plot")

# Show that coordinates are reversed:
myplot + theme_classic()

# Or add to plot as annotation
image <- image_fill(logo, 'none')
raster <- as.raster(image)
myplot <- qplot(mpg, wt, data = mtcars)
myplot + annotation_raster(raster, 25, 35, 3, 5)

# Or overplot image using grid
library(grid)
qplot(speed, dist, data = cars, geom = c("point", "smooth"))
grid.raster(image)
}
