% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{updateValues}
\alias{updateValues}
\title{Analogous to the '/update' function of magma}
\usage{
updateValues(
  target,
  projectName,
  revisions = list(),
  auto.proceed = FALSE,
  ...
)
}
\arguments{
\item{target}{A list, which can be created using \code{\link{magmaRset}}, containing your authorization 'token' (a string), a 'url' of magma to target (a string), and optional 'opts' for specifying additions parameters for curl requests (a named list).}

\item{projectName}{Single string. The name of the project you would like to interact with. For options, see \code{\link{retrieveProjects}}.}

\item{revisions}{A list of named lists containing the data to be updated.

List structure:
\itemize{
\item top level name(s): modelNames, can be 1 or more.
\item 2nd level name(s): recordNames, can be 1 or more.
\item 3rd level name(s) & contents: the attributes to update & the values to use.
}

See \url{https://mountetna.github.io/magma.html#update} for additional formatting details.}

\item{auto.proceed}{Logical. When set to TRUE, the function does not ask before proceeding forward with the 'magma/update'.}

\item{...}{Additional parameters passed along to the internal `.retrieve()`, `.query()`, or `.update()` functions,
for troubleshooting or advanced-user purposes only: \itemize{
\item \code{request.only} (Logical) & \code{json.params.only} (Logical) which 1) stop the function before its main curl request to magma and 2) returns the values that would have been sent to magma in either of two formats.
\item \code{verbose} (Logical) sets whether to report the status of the curl request after it is performed.
}}
}
\value{
None directly.

The function sends data to magma, and the only outputs are information reported via the console.
}
\description{
Analogous to the '/update' function of magma, allows data to be sent to magma (by users with at least "editor" authorization).
}
\details{
This function mimics the activity of the magma/update function, documented here \url{https://mountetna.github.io/magma.html#update},
with the main difference being that the \code{revisions} input should be in nested list format rather than nested hash (because R does not support hash structures).

Internally, the function:

1. Summarizes records of each model that will be targeted for updating.

2. Prompts the user before proceeding (unless \code{auto.proceed} is set to \code{TRUE})

3. Directly passes its inputs along to magma/update via a curl request.
}
\examples{

if (interactive()) {
    # First, we use magmaRset to create an object which will tell other magmaR
    #  functions our authentication token (as well as some other optional bits).
    # When run in this way, it will ask you to give your token.
    magma <- magmaRset()
    
    # Note that you likely do not have write-permissions for the 'example'
    # project, so this code can be expected to give an authorization error.

    updateValues(
        target = magma,
        projectName = "example",
        revisions = list(
            # model
            'rna_seq' = list(
                # record
                'EXAMPLE-HS1-WB1-RSQ1' = list(
                    # attribute
                    'fraction' = list(
                        # value(s)
                        "Tcells"
                        )
                    )
                )
            )
        )
}

}
\seealso{
\url{https://mountetna.github.io/magma.html#update} for documentation of the underlying magma/update function.

\code{\link{updateMatrix}} for a matrix-dedicated version of this function which can be provided a matrix, or matrix's file location, directly.
}
