% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forLoop.R
\name{forLoopToLapply}
\alias{forLoopToLapply}
\title{Transfrom For Loop To Lapply}
\usage{
forLoopToLapply(forloop)
}
\arguments{
\item{forloop}{R language object with class \code{for}.}
}
\value{
call R call to \code{parallel::mclapply} if successful,
 otherwise the original forloop.
}
\description{
Determine if a for loop can be parallelized, and if so transform it into
a call to \code{lapply}. This first version will modify loops if and
only if the body of the loop does not do any assignments at all.
}
\details{
Recommended use case:

The functions in the body of the loop write to different files on each
loop iteration.

The generated code WILL FAIL if:

Code in the body of the loop is truly iterative. Functions update global
state in any way other than direct assignment.
}
