% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_prior_object_functions.R
\name{makemyprior_example_model}
\alias{makemyprior_example_model}
\title{Returning a simple example prior object}
\usage{
makemyprior_example_model(seed = 1)
}
\arguments{
\item{seed}{A seed value for reproducing the data (default \code{seed = 1}).}
}
\value{
An object of class \code{mmp_prior}.
}
\description{
Creating a simple prior object using \link[makemyprior]{make_prior}.
Used in examples of other functions in the package.
}
\details{
See example for what model is made.
}
\examples{

ex_model <- makemyprior_example_model()

\dontrun{
# The function corresponds to the following model call:

set.seed(1)

data <- list(
  a = rep(1:10, each = 10),
  b = rep(1:10, times = 10)
)
data$y <- rnorm(10, 0, 0.4)[data$a] + rnorm(10, 0, 0.6)[data$b] + rnorm(100, 0, 1)

formula <- y ~ mc(a) + mc(b)

prior <- make_prior(formula, data, family = "gaussian",
                    prior = list(tree = "s1 = (a, b); s2 = (s1, eps)",
                                 w = list(s2 = list(prior = "pc0", param = 0.25)),
                                 V = list(s2 = list(prior = "pc", param = c(3, 0.05)))),
                    intercept_prior = c(0, 1000))
}

}
