% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_posterior_diagnostics.R
\name{plot_posterior_fixed}
\alias{plot_posterior_fixed}
\title{Plotting posterior distributions}
\usage{
plot_posterior_fixed(obj)
}
\arguments{
\item{obj}{An object from \code{inference_stan} or \code{inference_inla}}
}
\value{
A \link[ggplot2]{ggplot} with the posterior distributions.
See also \link[makemyprior]{makemyprior_plotting}.
}
\description{
Function for plotting the posterior distributions of the coefficients of the fixed effects
}
\examples{

if (interactive() && requireNamespace("rstan")){
  ex_prior <- makemyprior_example_model()
  res_stan <- inference_stan(ex_prior, iter = 100)
  # Note: For reliable results, increase the number of iterations (e.g., 'iter = 2000')
  plot_posterior_fixed(res_stan)
}

}
\keyword{plot}
