% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getShp.R
\name{getShp}
\alias{getShp}
\title{Download MAPadmin2013 Administrative Boundary Shapefiles from the MAP geoserver}
\usage{
getShp(country = NULL, ISO = NULL, extent = NULL, admin_level = "both",
  format = "spatialpolygon", long = NULL, lat = NULL)
}
\arguments{
\item{country}{string containing name of desired country, e.g. \code{ c("Country1", "Country2", ...)} OR \code{ = "ALL"} (use either \code{ISO} OR \code{country})}

\item{ISO}{string containing ISO3 code for desired country, e.g. \code{c("XXX", "YYY", ...)} OR \code{ = "ALL"} (use either \code{ISO} OR \code{country})}

\item{extent}{2x2 matrix specifying the spatial extent within which polygons are desired, as returned by sp::bbox() - the first column has the minimum, the second the maximum values; rows 1 & 2 represent the x & y dimensions respectively (matrix(c("xmin", "ymin","xmax", "ymax"), nrow = 2, ncol = 2, dimnames = list(c("x", "y"), c("min", "max")))).
Note: getShp downloads the entire polygon for any polygons falling within the extent.}

\item{admin_level}{string specifying the administrative level for which shapefile are desired (only "admin1", "admin0", or "both" accepted)}

\item{format}{string specifying the desired format for the downloaded shapefile: either "spatialpolygon" or "df"}

\item{long}{longitude of a point location falling within the desired shapefile.}

\item{lat}{latitude of a point location falling within the desired shapefile.}
}
\value{
\code{getShp} returns either a dataframe or spatialPolygon object for requested administrative unit polygons. The following attribute fields are included:

\enumerate{
\item \code{COUNTRY_ID} ISO-3 code of given administrative unit (or the ISO code of parent unit for administrative-level 1 units).
\item \code{GAUL_CODE} GAUL code of given administrative unit.
\item \code{ADMN_LEVEL} administrative level of the given administrative unit - either 0 (national) or 1 (first-level division)
\item \code{PARENT_ID} GAUL code of parent administrative unit of a given polygon (for admin0 polygons, PARENT_ID = 0).
\item \code{country_level} composite \code{ISO3}_\code{ADMN_LEVEL} field.
}
}
\description{
\code{getShp} downloads a shapefile for a specified country (or countries) and returns this as either a spatialPolygon or data.frame object.
}
\examples{
#Download PfPR data & associated shapefiles for Nigeria and Cameroon
\donttest{
NGA_CMR_PR <- getPR(country = c("Nigeria", "Cameroon"), species = "Pf")
NGA_CMR_shp <- getShp(country = c("Nigeria", "Cameroon"))

#Download PfPR data & associated shapefiles for Chad
Chad_PR <- getPR(ISO = "TCD", species = "both")
Chad_shp <- getShp(ISO = "TCD")

#' #Download PfPR data & associated shapefiles defined by extent for Madagascar
MDG_PR <- getPR(country = "Madagascar", species = "Pv")
}


}
\seealso{
\code{autoplot} method for quick mapping of PR point locations (\code{\link{autoplot.pr.points}}).
}
