% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isAvailable_vec.R
\name{isAvailable_vec}
\alias{isAvailable_vec}
\title{Check whether Vector Occurrence points are available for a given location}
\usage{
isAvailable_vec(sourcedata = "vector points", country = NULL, ISO = NULL,
  continent = NULL, full_results = FALSE)
}
\arguments{
\item{sourcedata}{by default this is "vector points", highlighting the dataset to be searched}

\item{country}{string containing name of desired country, e.g. \code{ c("Country1", "Country2", ...)} (use one of \code{country} OR \code{ISO} OR \code{continent}, not combined)}

\item{ISO}{string containing ISO3 code for desired country, e.g. \code{c("XXX", "YYY", ...)} (use one of \code{country} OR \code{ISO} OR \code{continent}, not combined)}

\item{continent}{string containing name of continent for desired data, e.g. \code{c("Continent1", "Continent2", ...)}(use one of \code{country} OR \code{ISO} OR \code{continent}, not combined)}

\item{full_results}{By default this is FALSE meaning the function only gives a message outlining whether specified country is available, if \code{full_results == TRUE}, the function returns a named list outlining data availability.}
}
\value{
\code{isAvailable_Vec} returns a named list of input locations with information regarding data availability.

if \code{full_results == TRUE}, a named list is returned with the following elements:
\enumerate{
\item \code{location} - specified input locations
\item \code{is_available}- 1 or 0; indicating whether data is available for this location
\item \code{possible_match}- agrep-matched country names indicating potential mispellings of countries where is_available == 0; NA if data is available for this location.
}
}
\description{
\code{isAvailable_vec} checks whether the MAP database contains Vector Occurrence points for the specified country/location.
}
\examples{
\donttest{
isAvailable_vec(country = "Suriname")
x <- isAvailable_vec(ISO = "NGA", full_results = TRUE)
x <- isAvailable_vec(continent = "Oceania", full_results = TRUE)
}
}
