/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.algorithm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import salvo.jesus.graph.DirectedAcyclicGraph;
import salvo.jesus.graph.NullVisitor;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.Visitor;
import salvo.jesus.graph.algorithm.DepthFirstDirectedGraphTraversal;
import salvo.jesus.graph.algorithm.GraphTraversal;

public class TopologicalSorting
extends GraphTraversal {
    private DirectedAcyclicGraph dag;

    public TopologicalSorting(DirectedAcyclicGraph dag) {
        super(dag);
        this.dag = dag;
    }

    public int traverse(Vertex startat, List visited, Visitor visitor) {
        DepthFirstDirectedGraphTraversal dfs = new DepthFirstDirectedGraphTraversal(this.dag);
        List vertices = dfs.traverse(startat);
        HashMap<Vertex, RefCount> vertexMap = new HashMap<Vertex, RefCount>(vertices.size());
        Iterator vertexIter = vertices.iterator();
        while (vertexIter.hasNext()) {
            Vertex v = (Vertex)vertexIter.next();
            Iterator children = this.dag.getOutgoingAdjacentVertices(v).iterator();
            while (children.hasNext()) {
                Vertex child = (Vertex)children.next();
                RefCount refCount = (RefCount)vertexMap.get(child);
                if (refCount == null) {
                    refCount = new RefCount();
                    vertexMap.put(child, refCount);
                }
                ++refCount.nRefs;
            }
        }
        ArrayList<Vertex> rootList = new ArrayList<Vertex>();
        rootList.add(startat);
        this.traverseImpl(vertexMap, rootList, visited, visitor);
        return 1;
    }

    public List traverse(Vertex startat, Visitor visitor) {
        ArrayList visited = new ArrayList(10);
        this.traverse(startat, visited, visitor);
        return visited;
    }

    public List traverse(Vertex startat) {
        return this.traverse(startat, new NullVisitor());
    }

    public List reverseTraverse(Vertex startat) {
        List sortSequence = this.traverse(startat, new NullVisitor());
        Collections.reverse(sortSequence);
        return sortSequence;
    }

    public List traverse() {
        HashMap<Vertex, RefCount> vertexMap = new HashMap<Vertex, RefCount>(this.dag.getVerticesCount());
        ArrayList<Vertex> rootList = new ArrayList<Vertex>();
        Iterator vertexIter = this.dag.getVerticesIterator();
        while (vertexIter.hasNext()) {
            Vertex v = (Vertex)vertexIter.next();
            int nRefs = this.dag.getIncomingEdges(v).size();
            if (nRefs == 0) {
                rootList.add(v);
                continue;
            }
            RefCount refCount = new RefCount();
            refCount.nRefs = nRefs;
            vertexMap.put(v, refCount);
        }
        ArrayList visitedList = new ArrayList(vertexMap.size());
        this.traverseImpl(vertexMap, rootList, visitedList, new NullVisitor());
        return visitedList;
    }

    public List reverseTraverse() {
        List sortSequence = this.traverse();
        Collections.reverse(sortSequence);
        return sortSequence;
    }

    private void traverseImpl(Map vertexMap, List rootList, List visitedList, Visitor visitor) {
        if (!visitedList.isEmpty()) {
            throw new IllegalArgumentException("initial visited List must be empty");
        }
        int nVertices = vertexMap.size() + rootList.size();
        while (!rootList.isEmpty()) {
            Vertex v = (Vertex)rootList.remove(rootList.size() - 1);
            visitedList.add(v);
            visitor.visit(v);
            Iterator childIter = this.dag.getOutgoingAdjacentVertices(v).iterator();
            while (childIter.hasNext()) {
                Vertex child = (Vertex)childIter.next();
                RefCount refCount = (RefCount)vertexMap.get(child);
                --refCount.nRefs;
                if (refCount.nRefs != 0) continue;
                rootList.add(child);
            }
        }
        if (visitedList.size() != nVertices) {
            throw new IllegalArgumentException("cycle detected in DAG");
        }
    }

    private static class RefCount {
        int nRefs;

        private RefCount() {
        }
    }
}

