/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.extract.test;

import cc.mallet.extract.DocumentExtraction;
import cc.mallet.extract.Extraction;
import cc.mallet.extract.PerDocumentF1Evaluator;
import cc.mallet.extract.PerFieldF1Evaluator;
import cc.mallet.extract.PunctuationIgnoringComparator;
import cc.mallet.extract.RegexFieldCleaner;
import cc.mallet.extract.Tokenization;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.PrintInputAndTarget;
import cc.mallet.pipe.SGML2TokenSequence;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.pipe.Target2LabelSequence;
import cc.mallet.pipe.iterator.ArrayIterator;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.Sequence;
import cc.mallet.util.CharSequenceLexer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestPerDocumentF1Evaluator
extends TestCase {
    private static String[] testPred = new String[]{"<eater>the big red fox</eater> did it", "it was done by <meal>the dog</meal>", "<eater>the cat</eater> ate the <meal>canary</meal>", "<meal>the hamburger</meal> was eaten by the kid", "<eater>the dog</eater> was eaten with zest", "four score and seven years <meal>ago</meal>"};
    private static String[] testTrue = new String[]{"<eater>the big red fox</eater> did it", "it was done by <eater>the dog</eater>", "<eater>the cat</eater> ate <meal>the canary</meal>", "<meal>the hamburger</meal> was eaten by <eater>the kid</eater>", "<meal>the dog</meal> was eaten with zest", "four score and seven years ago"};
    private static final String testAExpected = "Testing per-document F1\nName\tP\tR\tF1\neater\t0.6667\t0.5\t0.5714\nO\t0\t1\t0\nmeal\t0.25\t0.3333\t0.2857\nOVERALL (micro-averaged) P=0.4286 R=0.4286 F1=0.4286\nOVERALL (macro-averaged) F1=0.4286\n\n";
    private static final String[] mpdPred = new String[]{"<title>Wizard of Oz</title> by <author>John Smith</author> and <author>Adam Felber</author>", "<title>Jisp Boo Fuzz by</title> the estimable <title>Rich Q. Doe</title> and <author>Frank Wilson</author>", "<title>Howdy Doody</title> if you think this is Mr. nonsense <author>don't you huh</author>"};
    private static final String[] mpdTrue = new String[]{"<title>Wizard of Oz</title> by <author>John Smith</author> and <author>Adam Felber</author>", "<title>Jisp Boo Fuzz</title> by the estimable <author>Rich Q. Doe</author> and <author>Frank Wilson</author>", "<title>Howdy Doody</title> if <title>you</title> think this is <title>Mr.</title> <author> nonsense don't you huh</author>"};
    private static final String mpdExpected = "Testing SEGMENT counts\nName\tCorrect\tPred\tTarget\ntitle\t2\t4\t5\nO\t0\t0\t0\nauthor\t3\t4\t5\n\nTesting per-field F1\nName\tP\tR\tF1\ntitle\t0.5\t0.4\t0.4444\nO\t0\t1\t0\nauthor\t0.75\t0.6\t0.6667\nOVERALL (micro-averaged) P=0.625 R=0.5 F1=0.5556\nOVERALL (macro-averaged) F1=0.5556\n\n";
    private static final String[] punctPred = new String[]{"<title>Wizard of Oz,</title> by <author>John Smith</author> and <author>Adam Felber</author>", "<title>Jisp Boo Fuzz by</title> the estimable <title>Rich Q. Doe</title> and <author>Frank Wilson</author>", "<title>Howdy Doody</title>!, if you think this is Mr. nonsense <author>don't you huh</author>"};
    private static final String[] punctTrue = new String[]{"<title>Wizard of Oz</title>, by <author>John Smith</author> and <author>Adam Felber</author>", "<title>Jisp Boo Fuzz</title> by the estimable <author>Rich Q. Doe</author> and <author>Frank Wilson</author>", "<title>Howdy Doody!</title>, if <title>you</title> think this is <title>Mr.</title> <author> nonsense don't you huh</author>"};

    public TestPerDocumentF1Evaluator(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(TestPerDocumentF1Evaluator.class);
    }

    private Extraction createExtractionFrom(String[] predStrings, String[] trueStrings) {
        SerialPipes pipe = new SerialPipes(new Pipe[]{new SGML2TokenSequence(new CharSequenceLexer(CharSequenceLexer.LEX_NONWHITESPACE_CLASSES), "O"), new Target2LabelSequence(), new PrintInputAndTarget()});
        InstanceList pred = new InstanceList(pipe);
        pred.addThruPipe(new ArrayIterator(predStrings));
        InstanceList targets = new InstanceList(pipe);
        targets.addThruPipe(new ArrayIterator(trueStrings));
        LabelAlphabet dict = (LabelAlphabet)pipe.getTargetAlphabet();
        Extraction extraction = new Extraction(null, dict);
        for (int i = 0; i < pred.size(); ++i) {
            Instance aPred = (Instance)pred.get(i);
            Instance aTarget = (Instance)targets.get(i);
            Tokenization input = (Tokenization)aPred.getData();
            Sequence predSeq = (Sequence)aPred.getTarget();
            Sequence targetSeq = (Sequence)aTarget.getTarget();
            DocumentExtraction docextr = new DocumentExtraction("TEST" + i, dict, input, predSeq, targetSeq, "O");
            extraction.addDocumentExtraction(docextr);
        }
        return extraction;
    }

    public void testPerDocEval() {
        Extraction extraction = this.createExtractionFrom(testPred, testTrue);
        PerDocumentF1Evaluator eval = new PerDocumentF1Evaluator();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        eval.setErrorOutputStream(System.out);
        eval.evaluate("Testing", extraction, new PrintWriter((Writer)new OutputStreamWriter(out), true));
        String output = out.toString();
        TestPerDocumentF1Evaluator.assertEquals((String)testAExpected, (String)output);
    }

    public void testPerFieldEval() {
        Extraction extraction = this.createExtractionFrom(mpdPred, mpdTrue);
        PerFieldF1Evaluator eval = new PerFieldF1Evaluator();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        eval.evaluate("Testing", extraction, new PrintStream(out));
        TestPerDocumentF1Evaluator.assertEquals((String)mpdExpected, (String)out.toString());
    }

    public void testToStdout() {
        Extraction extraction = this.createExtractionFrom(mpdPred, mpdTrue);
        PerFieldF1Evaluator eval = new PerFieldF1Evaluator();
        eval.evaluate(extraction);
        System.out.println("*** Please verify that something was output above.");
    }

    public void testPunctuationIgnoringEvaluator() {
        Extraction extraction = this.createExtractionFrom(punctPred, punctTrue);
        PerFieldF1Evaluator eval = new PerFieldF1Evaluator();
        eval.setComparator(new PunctuationIgnoringComparator());
        eval.setErrorOutputStream(System.out);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        eval.evaluate("Testing", extraction, new PrintStream(out));
        TestPerDocumentF1Evaluator.assertEquals((String)mpdExpected, (String)out.toString());
    }

    public void testFieldCleaning() {
        Extraction extraction = this.createExtractionFrom(punctPred, punctTrue);
        extraction.cleanFields(new RegexFieldCleaner("<.*?>|,|!"));
        PerFieldF1Evaluator eval = new PerFieldF1Evaluator();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        eval.evaluate("Testing", extraction, new PrintStream(out));
        TestPerDocumentF1Evaluator.assertEquals((String)mpdExpected, (String)out.toString());
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest((Test)new TestPerDocumentF1Evaluator(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestPerDocumentF1Evaluator.suite();
        }
        TestRunner.run((Test)theSuite);
    }
}

