% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcanor.R
\name{volcanor}
\alias{volcanor}
\title{Creates a volcano object}
\usage{
volcanor(
  x,
  p = "P",
  effect_size = "EFFECTSIZE",
  snp,
  gene,
  annotation1,
  annotation2,
  ...
)
}
\arguments{
\item{x}{A \code{data.frame} which must contain at least the following
columns: \itemize{ \item{a p-value, must be numeric} \item{a measure of the
strength of association, typically an odds ratio, regression coefficient or
log fold change. Must be numeric} }}

\item{p}{A chracter string denoting the column name for the p-values. Default
is \code{p = "P"}. This column must be \code{numeric} or \code{integer}.
Should not have missing, NA, NaN, or NULL values and should be between 0
and 1.}

\item{effect_size}{A string denoting the column name for the effect size.
Default is \code{effect_size = "EFFECTSIZE"}. This column must be \code{numeric} or
\code{integer}. Should not have missing, NA, NaN, or NULL values.}

\item{snp}{A string denoting the column name for the SNP names (e.g. rs
number). This argument is optional but required if you want to highlight
any points. More generally, this column could be anything that identifies
each point being plotted. For example, in an Epigenomewide association
study (EWAS) this could be the probe name or cg number. This column should
contain \code{characters}. This argument is necessary.
\code{\link{volcanoly}} function}

\item{gene}{A string denoting the column name for the GENE names. This column
could be a \code{character} or \code{numeric}. More generally this could be
any annotation information that you want to include in the plot. This
argument is optional.}

\item{annotation1}{A string denoting the column name for an annotation. This
column could be a \code{character} or \code{numeric}. This could be any
annotation information that you want to include in the plot (e.g. zscore,
effect size, minor allele frequency). This argument is optional.}

\item{annotation2}{A string denoting the column name for an annotation. This
column could be a \code{character} or \code{numeric}. This could be any
annotation information that you want to include in the plot (e.g. zscore,
effect size, minor allele frequency). This argument is optional.}

\item{...}{currently ignored}
}
\value{
An list object of class \code{volcanor} with the following elements
  \describe{  \item{data}{processed data to be used for plotting the volcano
  plot including the observed and expected p-values on the -log10 scale}
  \item{pName, snpName, geneName, annotation1Name, annotation2Name}{The names
  of the columns corresponding to the data provided. This information is used
  for annotating the plot in the \code{\link{volcanoly}} function } }
}
\description{
An object of class volcano includes all the needed information for producing
a volcano plot of p-values against effect sizes or fold-changes. The goal is
to seperate the pre-processing of the volcano plot elements from the
graphical rendaring of the object, which could be done using any graphical
device including \code{\link[plotly]{plot_ly}} and
\code{\link[graphics]{plot}} in base \code{R}.
}
\note{
This function will return an error if any of the p-values are NA, less
  than 0 or greater than 1
}
\examples{
library(manhattanly)
volcanorObj <- volcanor(HapMap)
class(volcanorObj)
head(volcanorObj)
}
\seealso{
\code{\link{volcanoly}}
}
