% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/codes.R
\name{count_codes}
\alias{count_codes}
\title{Count the codings from a ManifestoDocument}
\usage{
count_codes(doc, code_layers = c("cmp_code"), with_eu_codes = "auto",
  prefix = "per", relative = TRUE, include_codes = if ("cmp_code" \%in\%
  code_layers) {     v4_categories() } else {     c() })
}
\arguments{
\item{doc}{ManifestoDocument, ManifestoCorpus or vector of codes}

\item{code_layers}{vector of names of code layers to use, defaults to cmp_code; Caution:
The layer eu_code is handled separately in the parameter with_eu_codes due to its
different logic}

\item{with_eu_codes}{Whether to include special EU code layer; by default ("auto") taken
from the document's metadata}

\item{prefix}{prefix for naming the count/percentage columns in the resulting data.frame}

\item{relative}{If true, percentages are returned, absolute counts else}

\item{include_codes}{Vector of categories that should be included even if they are not
present in the data; the value of the created variables then defaults to 0.0 (or NA if
no codes are present at all);}
}
\value{
A data.frame with onw row and the counts/percentages as columns
}
\description{
Count the codings from a ManifestoDocument
}

