% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold_functions.R
\name{calculate_cropland_threshold}
\alias{calculate_cropland_threshold}
\title{Calculate Cropland Threshold for Exclusion}
\usage{
calculate_cropland_threshold(
  county_data,
  target_data,
  county_cropland_col,
  target_cropland_col,
  baseline_ha = 500
)
}
\arguments{
\item{county_data}{Data frame. County-level NuGIS data with cropland column}

\item{target_data}{Data frame. Target scale data (HUC8, HUC2) with cropland column}

\item{county_cropland_col}{Character. Name of cropland column in county data}

\item{target_cropland_col}{Character. Name of cropland column in target data}

\item{baseline_ha}{Numeric. Baseline cropland in hectares for exclusion (default: 500)}
}
\value{
Numeric. Threshold value for target scale
}
\description{
Calculate cropland threshold for excluding small agricultural areas
Uses county 500ha baseline to determine percentile for other scales
}
