% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{summarize_results}
\alias{summarize_results}
\title{Print Summary of Analysis Results}
\usage{
summarize_results(results, detailed = FALSE)
}
\arguments{
\item{results}{List. Analysis results from \code{\link{run_builtin_analysis}} or
\code{\link{run_state_analysis}}. Must contain at minimum:
\itemize{
\item \code{parameters}: List with scale, year, nutrients, include_wwtp
\item \code{agricultural}: sf data frame with classification columns
}
Optional components:
\itemize{
\item \code{wwtp}: WWTP analysis results
\item \code{integrated}: Integrated classification results
\item \code{created_files} or \code{saved_files}: Output file paths
}}

\item{detailed}{Logical. If TRUE, includes additional breakdown of integrated
classifications showing combined agricultural-WWTP nutrient classes. If FALSE
(default), shows only agricultural classifications and basic WWTP statistics.}
}
\value{
Invisibly returns the input \code{results} list unchanged. The function
is called primarily for its side effect of printing a formatted summary to the
console. The invisible return allows for piping operations while displaying
the summary.
}
\description{
Print formatted summary of manureshed analysis results to the console.
The summary includes analysis configuration parameters (scale, year, nutrients,
WWTP inclusion), spatial coverage statistics, agricultural nutrient classifications
with counts and percentages, WWTP integration metrics (if applicable), integrated
classifications (if available), output file information, and processing time.
}
\details{
The summary output is organized into sections:
\describe{
\item{Analysis Configuration}{Scale, year, nutrients analyzed, WWTP inclusion, state (if applicable)}
\item{Spatial Coverage}{Total number of spatial units analyzed}
\item{Agricultural Classifications}{Nitrogen and phosphorus classification counts and percentages}
\item{WWTP Integration}{Number of facilities and total loads by nutrient (if applicable)}
\item{Integrated Classifications}{Combined agricultural-WWTP classes (if detailed = TRUE)}
\item{Output Files}{Number and types of created files (if saved)}
\item{Processing Time}{Analysis duration in minutes (if available)}
}

Classification names are cleaned for display (underscores replaced with spaces,
line breaks removed). Percentages are rounded to one decimal place. All console
output uses \code{\link{message}} and can be suppressed with
\code{\link{suppressMessages}}.
}
\examples{
\donttest{
# Basic summary
results <- run_builtin_analysis(scale = "county", year = 2016)
summarize_results(results)

# Detailed summary with integrated classifications
results <- run_builtin_analysis(
  scale = "huc8",
  year = 2012,
  include_wwtp = TRUE
)
summarize_results(results, detailed = TRUE)
}
\dontrun{
  # This requires magrittr - never auto-run
  library(magrittr)
  results <- run_builtin_analysis(scale = "huc2", year = 2015) \%>\%
    summarize_results() \%>\%
    export_for_gis(output_dir = tempdir())
}

}
\seealso{
\code{\link{run_builtin_analysis}} for generating analysis results,
\code{\link{quick_check}} for quick validation,
\code{\link{compare_analyses}} for comparing two result sets
}
