% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_profile.R
\name{db_profile}
\alias{db_profile}
\alias{db_plot}
\alias{db_comp}
\title{Database profile functions}
\usage{
db_plot(database, key = "manyID", variable = "all", category = "all")

db_comp(database, key = "manyID", variable = "all", category = "all")
}
\arguments{
\item{database}{A many database.}

\item{key}{A variable key to join datasets by, "manyID" by default.}

\item{variable}{Would you like to focus on one, or more, specific variables?
By default "all".
For multiple variables, please declare variable names as a vector.}

\item{category}{Would you like to focus on one specific code category?
By default "all" are returned.
Other options include "confirmed", "unique", "missing", "conflicting",
or "majority".
For multiple variables, please declare categories as a vector.}
}
\value{
A plot, or a tibble, with the profile of the variables across all
datasets in a "many" database.
For multiple categories across multiple variables,
the functions return all rows that contain at least one of the selected
variables coded as one of the categories.
}
\description{
Database profiling functions that returns confirmed, unique,
missing, conflicting, or majority values in all (non-ID) variables
in the datasets in a 'many' package database.
}
\details{
Confirmed values are the same in all datasets in database.
Unique values appear once in datasets in database.
Missing values are missing in all datasets in database.
Conflicting values are different in the same number of datasets in database.
Majority values have the same value in multiple, but not all,
datasets in database.

\code{db_plot()} plots the database profile.

\code{db_comp()} creates a tibble comparing the variables in a database.
}
\examples{
\donttest{
db_plot(database = emperors, key = "ID")
db_plot(database = emperors, key = "ID", variable = c("Beg", "End"))
db_plot(database = emperors, key = "ID", variable = c("Beg", "End"),
category = c("conflict", "unique"))
}
\donttest{
db_comp(database = emperors, key = "ID")
db_comp(database = emperors, key = "ID", variable = "Beg")
db_comp(database = emperors, key = "ID", variable = c("Beg", "End"),
category = "conflict")
db_comp(database = emperors, key = "ID", variable = c("Beg", "End"),
category = c("conflict", "unique"))
}
}
