% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_ison.R
\docType{data}
\name{ison_marvel}
\alias{ison_marvel}
\alias{ison_marvel_teams}
\alias{ison_marvel_relationships}
\title{Multilevel two-mode affiliation, signed one-mode networks of Marvel comic
book characters (Yuksel 2017)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> # A labelled, two-mode network of 194 nodes and 683 ties
#> # A tibble: 194 x 2
#>   type  name         
#>   <lgl> <chr>        
#> 1 FALSE Abomination  
#> 2 FALSE Ant-Man      
#> 3 FALSE Apocalypse   
#> 4 FALSE Beast        
#> 5 FALSE Black Panther
#> 6 FALSE Black Widow  
#> # i 188 more rows
#> # A tibble: 683 x 2
#>    from    to
#>   <int> <int>
#> 1     1   120
#> 2     1   152
#> 3     1   160
#> 4     1   162
#> 5     1   179
#> 6     2    56
#> # i 677 more rows
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> # A labelled, complex, signed, undirected network of 53 nodes and 558 ties
#> # A tibble: 53 x 10
#>   name     Gender Appearances Attractive  Rich Intellect Omnilingual PowerOrigin
#>   <chr>    <chr>        <int>      <int> <int>     <int>       <int> <chr>      
#> 1 Abomina~ Male           427          0     0         1           1 Radiation  
#> 2 Ant-Man  Male           589          1     0         1           0 Human      
#> 3 Apocaly~ Male          1207          0     0         1           1 Mutant     
#> 4 Beast    Male          7609          1     0         1           0 Mutant     
#> 5 Black P~ Male          2189          1     1         1           0 Human      
#> 6 Black W~ Female        2907          1     0         1           0 Human      
#> # i 47 more rows
#> # i 2 more variables: UnarmedCombat <int>, ArmedCombat <int>
#> # A tibble: 558 x 3
#>    from    to  sign
#>   <int> <int> <dbl>
#> 1     1     4    -1
#> 2     1    11    -1
#> 3     1    12    -1
#> 4     1    23    -1
#> 5     1    24    -1
#> 6     1    25    -1
#> # i 552 more rows
}\if{html}{\out{</div>}}
}
\source{
Umut Yuksel, 31 March 2017
}
\usage{
data(ison_marvel_teams)

data(ison_marvel_relationships)
}
\description{
This package includes two datasets related to the Marvel \emph{comic book} universe.
The first, \code{ison_marvel_teams},  is a two-mode affiliation network of 53
Marvel comic book characters and their affiliations to 141 different teams.
This network includes only information about nodes' names and nodeset,
but additional nodal data can be taken from the other Marvel dataset here.

The second network, \code{ison_marvel_relationships}, is a one-mode signed network
of friendships and enmities between the 53 Marvel comic book characters.
Friendships are indicated by a positive sign in the tie \code{sign} attribute,
whereas enmities are indicated by a negative sign in this edge attribute.
}
\details{
Additional nodal variables have been coded and included by Dr Umut Yuksel:
\itemize{
\item \strong{Gender}: binary character, 43 "Male" and 10 "Female"
\item \strong{PowerOrigin}: binary character, 2 "Alien", 1 "Cyborg", 5 "God/Eternal",
22 "Human", 1 "Infection", 16 "Mutant", 5 "Radiation", 1 "Robot"
\item \strong{Appearances}: integer, in how many comic book issues they appeared in
\item \strong{Attractive}: binary integer, 41 1 (yes) and 12 0 (no)
\item \strong{Rich}: binary integer, 11 1 (yes) and 42 0 (no)
\item \strong{Intellect}: binary integer, 39 1 (yes) and 14 0 (no)
\item \strong{Omnilingual}: binary integer, 8 1 (yes) and 45 0 (no)
\item \strong{UnarmedCombat}: binary integer, 51 1 (yes) and 2 0 (no)
\item \strong{ArmedCombat}: binary integer, 25 1 (yes) and 28 0 (no)
}
}
\keyword{datasets}
