% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_ison.R
\docType{data}
\name{ison_karateka}
\alias{ison_karateka}
\title{One-mode karateka network (Zachary 1977)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> -- # Zachary's karate club network ---------------------------------------------
#> # A labelled, weighted, undirected network of 34 club members and 78
#> association ties
#> 
#> -- Nodes
#> # A tibble: 34 x 2
#>   name  allegiance
#>   <chr>      <dbl>
#> 1 Mr Hi          1
#> 2 2              1
#> 3 3              1
#> 4 4              1
#> 5 5              1
#> 6 6              1
#> # i 28 more rows
#> 
#> -- Ties
#> # A tibble: 78 x 3
#>    from    to weight
#>   <int> <int>  <dbl>
#> 1     1     2      4
#> 2     1     3      5
#> 3     2     3      6
#> 4     1     4      3
#> 5     2     4      3
#> 6     3     4      3
#> # i 72 more rows
#> 
}\if{html}{\out{</div>}}
}
\usage{
data(ison_karateka)
}
\description{
The network was observed in a university Karate club in 1977.
The network describes association patterns among 34 members
and maps out allegiance patterns between members and either Mr. Hi,
the instructor, or the John A. the club president
after an argument about hiking the price for lessons.
The allegiance of each node is listed in the \code{obc} argument
which takes the value 1 if the individual sided with Mr. Hi after the fight
and 2 if the individual sided with John A.
}
\references{
Zachary, Wayne W. 1977. “An Information Flow Model for Conflict and Fission in Small Groups.”
\emph{Journal of Anthropological Research} 33(4):452–73.
\doi{10.1086/jar.33.4.3629752}.
}
\keyword{datasets}
