#' Data frame of Denmark's 98 municipalities
#'
#' A dataset containing the longitude and latitude of all of Denmark's 98 municipalities
#'
#' @format A data frame with 39184 rows and 4 variables:
#' \describe{
#'   \item{long}{Longitude of municipality}
#'   \item{lat}{Latitude of municipality}
#'   \item{group}{Groups, generated by \code{ggmap:fortify}}
#'   \item{id}{Name of municipality}
#' }
#' @source \url{Statistics Denmark}
"municipality"
#' Data frame of Denmark's 5 regions
#'
#' A dataset containing the longitude and latitude of all of Denmark's 5 regions
#'
#' @format A data frame with 32522 rows and 4 variables:
#' \describe{
#'   \item{long}{Longitude of region}
#'   \item{lat}{Latitude of region}
#'   \item{group}{Groups, generated by \code{ggmap:fortify}}
#'   \item{id}{Name of region}
#' }
#' @source \url{Statistics Denmark}
"region"
#' Data frame of Denmark's 11 rural areas
#'
#' A dataset containing the longitude and latitude of all of Denmark's 11 rural areas
#'
#' @format A data frame with 4083 rows and 4 variables:
#' \describe{
#'   \item{long}{Longitude of rural area}
#'   \item{lat}{Latitude of rural area}
#'   \item{group}{Groups, generated by \code{ggmap:fortify}}
#'   \item{id}{Name of rural area}
#' }
#' @source \url{Statistics Denmark}
"rural"
#' Data frame of Denmark's 598 zip code areas
#'
#' A dataset containing the longitude and latitude of all of Denmark's 598 zip oode areas
#'
#' @format A data frame with 49322 rows and 4 variables:
#' \describe{
#'   \item{long}{Longitude of zip code area}
#'   \item{lat}{Latitude of zip code area}
#'   \item{group}{Groups, generated by \code{ggmap:fortify}}
#'   \item{id}{Identification number of zip code area}
#' }
#' @source \url{Statistics Denmark}
"zip"
#' Data frame of Denmark's 1931 parishes
#'
#' A dataset containing the longitude and latitude of all of Denmark's 1931 parishes
#'
#' @format A data frame with 76156 rows and 4 variables:
#' \describe{
#'   \item{long}{Longitude of parish}
#'   \item{lat}{Latitude of parish}
#'   \item{group}{Groups, generated by \code{ggmap:fortify}}
#'   \item{id}{Identification number of parish}
#' }
#' @source \url{Statistics Denmark}
"parish"
#' Data frame of Denmark's 1385 polling places
#'
#' A dataset containing the longitude and latitude of all of Denmark's 1385 polling places
#'
#' @format A data frame with 155072 rows and 9 variables:
#' \describe{
#'   \item{long}{Longitude of polling place}
#'   \item{lat}{Latitude of polling place}
#'   \item{group}{Groups, generated by \code{ggmap:fortify}}
#'   \item{AfstemKod}{Longitude of polling place}
#'   \item{id}{Id of polling place}
#'   \item{KommuneNum}{Polling place municipality number}
#'   \item{KommuneNav}{Polling place municipality name}
#'   \item{OpstilNum}{...}
#'   \item{OpstilNav}{...}
#' }
#' @source \url{Statistics Denmark}
"polling"
#' Data frame of Danish 2011 election results
#'
#' A dataset containing election results from the Danish general election in 2011 at the polling place level for all major parties
#'
#' @format A data frame with 13774 rows and 3 variables:
#' \describe{
#'   \item{id}{Id of polling place}
#'   \item{navn}{Party name}
#'   \item{stemmer}{Votes (in pct)}
#' }
#' @source \url{http://www.dst.dk/valg/Valg1204271/xml/fintal.xml}
"votes"
#' Data frame of municipal burglaries
#'
#' A dataset containing number of burglaries at the municipality level from 2009
#'
#' @format A data frame with 98 rows and 5 variables:
#' \describe{
#'   \item{indbrud}{Number of burglaries}
#'   \item{year}{Year}
#'   \item{kommune}{Municipality name}
#'   \item{KOMNAVN}{Municipality name}
#'   \item{name}{Name}
#' }
#' @source Statistics Denmark
"crime"
