% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_prov.R
\name{esp_get_prov}
\alias{esp_get_prov}
\alias{esp_get_prov_siane}
\title{Get Provinces boundaries of Spain}
\source{
IGN data via a custom CDN (see
\url{https://github.com/rOpenSpain/mapSpain/tree/sianedata}).
}
\usage{
esp_get_prov(prov = NULL, ...)

esp_get_prov_siane(
  prov = NULL,
  year = Sys.Date(),
  epsg = "4258",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  resolution = "3",
  moveCAN = TRUE,
  rawcols = FALSE
)
}
\arguments{
\item{prov}{A vector of names and/or codes for provinces
or \code{NULL} to get all the provinces. See Details.}

\item{...}{
  Arguments passed on to \code{\link[=esp_get_nuts]{esp_get_nuts}}
  \describe{
    \item{\code{spatialtype}}{Type of geometry to be returned:
\itemize{
\item "RG": Regions - \code{MULTIPOLYGON/POLYGON} object.
\item "LB": Labels - \code{POINT} object.
}}
  }}

\item{year}{Release year. See \code{\link[=esp_get_nuts]{esp_get_nuts()}} for \code{esp_get_prov} and
Details for \code{esp_get_prov_siane}}

\item{epsg}{projection of the map: 4-digit \href{https://epsg.io/}{EPSG code}.
One of:
\itemize{
\item "4258": ETRS89
\item "4326": WGS84
\item "3035": ETRS89 / ETRS-LAEA
\item "3857": Pseudo-Mercator
}}

\item{cache}{A logical whether to do caching. Default is \code{TRUE}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source
\code{.geojson} file.}

\item{cache_dir}{A path to a cache directory. The directory can also be
set globally with:
\itemize{
\item \code{options(mapSpain_cache_dir = "path/to/dir")}.
}

See Details on \code{\link[=esp_get_nuts]{esp_get_nuts()}}.}

\item{verbose}{Display information. Useful for debugging,
default is \code{FALSE}.}

\item{resolution}{Resolution of the polygon. Values available are
"3", "6.5" or "10".}

\item{moveCAN}{A logical \code{TRUE/FALSE} or a vector of coordinates
\code{c(lat, lon)}. It places the Canary Islands close to Spain's mainland.
Initial position can be adjusted using the vector of coordinates.}

\item{rawcols}{Logical. Setting this to \code{TRUE} would add the raw columns of
the dataset provided by IGN.}
}
\value{
A \code{POLYGON/POINT} object.
}
\description{
Loads a simple feature (\code{sf}) object containing the province boundaries of
Spain.

\code{esp_get_prov} uses GISCO (Eurostat) as source

\code{esp_get_prov_siane} use CartoBase ANE as source, provided by Instituto
Geografico Nacional (IGN), \url{http://www.ign.es/web/ign/portal}. Years
available are 2005 up to today.
}
\details{
When using \code{prov} you can use and mix names and NUTS codes (levels 1, 2 or
3), ISO codes (corresponding to level 2 or 3) or \code{cpro}.

Ceuta and Melilla are considered as provinces on this dataset.

When calling a superior level (Autonomous Community or NUTS1) ,
all the provinces of that level would be added.

On \code{esp_get_prov_siane}, \code{year} could be passed as a single year ("YYYY"
format, as end of year) or as a specific date ("YYYY-MM-DD" format).
Historical information starts as of 2005.
}
\examples{

library(sf)

# Random Provinces

Random <-
  esp_get_prov(prov = c(
    "Zamora",
    "Palencia",
    "ES-GR",
    "ES521",
    "01"
  ))
plot(st_geometry(Random), col = hcl.colors(6))

# All Provinces of a Zone plus an addition
# Low resolution (20M)

Mix <-
  esp_get_prov(
    prov = c(
      "Noroeste",
      "Castilla y Leon", "La Rioja"
    ),
    resolution = "20"
  )
plot(
  Mix[, "nuts1.code"],
  pal = hcl.colors(3),
  key.pos = NULL,
  main = NULL,
  border = "white"
)
# ISO codes available

allprovs <- esp_get_prov()

library(tmap)

tmap_style("cobalt")

tm_shape(allprovs, point.per = "feature") +
  tm_polygons() +
  tm_text("iso2.prov.code", remove.overlap = TRUE)

tmap_options_reset()
}
\seealso{
\code{\link[=esp_get_hex_prov]{esp_get_hex_prov()}}, \code{\link[=esp_get_nuts]{esp_get_nuts()}}, \code{\link[=esp_get_ccaa]{esp_get_ccaa()}},
\code{\link[=esp_get_munic]{esp_get_munic()}}, \code{\link{esp_codelist}}.
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
\concept{political}
