% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addProviderEspTiles.R
\name{addProviderEspTiles}
\alias{addProviderEspTiles}
\alias{providerEspTileOptions}
\title{Include base tiles of Spanish public administrations on a \pkg{leaflet} map}
\source{
\url{https://dieghernan.github.io/leaflet-providersESP/} leaflet plugin,
\strong{v1.3.2}.
}
\usage{
addProviderEspTiles(
  map,
  provider,
  layerId = NULL,
  group = NULL,
  options = providerEspTileOptions()
)

providerEspTileOptions(...)
}
\arguments{
\item{map}{A map widget created from \code{\link[leaflet:leaflet]{leaflet::leaflet()}}.}

\item{provider}{Name of the provider, see \link{esp_tiles_providers} for
values available.}

\item{layerId}{the layer id}

\item{group}{The name of the group the newly created layers should belong to
Human-friendly group names are permitted–they need not be short,
identifier-style names. Any number of layers and even different types of
layers (e.g. markers and polygons) can share the same group name. See
\code{\link[leaflet:map-layers]{leaflet::addTiles()}}.}

\item{options}{a list of extra options for tile layers, popups, paths
(circles, rectangles, polygons, ...), or other map elements}

\item{...}{Arguments passed on to \code{\link[leaflet:addProviderTiles]{leaflet::providerTileOptions()}}.}
}
\value{
A map object generated with \code{\link[leaflet:leaflet]{leaflet::leaflet()}}.
}
\description{
Include tiles of public Spanish organisms to a
\code{\link[leaflet:leaflet]{leaflet::leaflet()}} map.
}
\details{
\code{\link[=providerEspTileOptions]{providerEspTileOptions()}} is a wrapper of
\code{\link[leaflet:addProviderTiles]{leaflet::providerTileOptions()}}.
}
\examples{
library(leaflet)
PuertadelSol <-
  leaflet() \%>\%
  setView(
    lat = 40.4166,
    lng = -3.7038400,
    zoom = 18
  ) \%>\%
  addProviderEspTiles(provider = "IGNBase.Gris") \%>\%
  addProviderEspTiles(provider = "RedTransporte.Carreteras")

PuertadelSol
}
\seealso{
\code{\link[leaflet:leaflet]{leaflet::leaflet()}}, \code{\link[leaflet:map-layers]{leaflet::addTiles()}}

\code{\link[leaflet:addProviderTiles]{leaflet::providerTileOptions()}}, \code{\link[leaflet:map-options]{leaflet::tileOptions()}}

Other imagery utilities: 
\code{\link{esp_getTiles}()},
\code{\link{esp_make_provider}()},
\code{\link{esp_tiles_providers}}
}
\concept{imagery utilities}
