% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accounts.R
\name{mb_access_token}
\alias{mb_access_token}
\alias{list_tokens}
\title{Install a Mapbox access token in your .Renviron for repeated use}
\usage{
mb_access_token(token, overwrite = FALSE, install = FALSE)

list_tokens(
  username,
  default = NULL,
  limit = NULL,
  sortby = "created",
  usage = NULL,
  access_token = NULL
)
}
\arguments{
\item{token}{The Mapbox access token; can be public (starting with 'pk') or secret (starting with 'sk') scope, which the function will interpret for you}

\item{overwrite}{Whether or not to overwrite an existing Mapbox access token.  Defaults to FALSE.}

\item{install}{if TRUE, will install the key in your \code{.Renviron} file for use in future sessions.  Defaults to FALSE.}

\item{username}{The Mapbox username for which you'd like to list access tokens.}

\item{default}{If TRUE, will only include the default token for an account. If FALSE, will include all other tokens except for the default.  Defaults to NULL.}

\item{limit}{The maximum number of tokens to return. Defaults to NULL.}

\item{sortby}{How to sort the returned tokens; one of \code{"created"} or \code{"modified"}.}

\item{usage}{If \code{"pk"}, returns only public tokens; if \code{"sk"}, returns only secret tokens.  Defaults to \code{NULL}, which returns all tokens in the scope of the supplied access token.}

\item{access_token}{Your Mapbox access token.  If left blank, will first check to see if you have a secret token stored in .Renviron, then a public token.}
}
\value{
A tibble of information about tokens in your Mapbox account.
}
\description{
Install a Mapbox access token in your .Renviron for repeated use

List tokens from a Mapbox account
}
\examples{
\dontrun{
my_token <- "..." # The token generated from your Mapbox account
mb_access_token(my_token, install = TRUE)
Sys.getenv("MAPBOX_PUBLIC_TOKEN")
}
\dontrun{

token_list <- list_tokens(
  username = "kwalkertcu", # You would use your own username here
  limit = 10,
  sortby = "modified"#'
)

}

}
