% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_herlang.R
\docType{class}
\name{herlang-class}
\alias{herlang-class}
\title{Class of hyper Erlang}
\description{
Parameters for a hyper Erlang.
}
\section{Slots}{

\describe{
\item{\code{size}}{The number of components (hyper Erlang components).}

\item{\code{mixrate}}{A vector of mixed rates (probability for selecting a component).}

\item{\code{shape}}{Shape parameters for Erlang distributions.}

\item{\code{rate}}{Rate parameters for Erlang distributions.}
}}

\note{
Objects are usually created by a \link{herlang}.
This class can be converted to \code{\linkS4class{ph}}.

Methods:
\describe{
\item{ph.moment}{\code{signature(ph = "herlang")}: ... }
\item{emfit.init}{\code{signature(model = "herlang", data = "phdata.wtime")}: ... }
\item{emfit.init}{\code{signature(model = "herlang", data = "phdata.group")}: ... }
\item{emfit.estep}{\code{signature(model = "herlang", data = "phdata.wtime")}: ... }
\item{emfit.estep}{\code{signature(model = "herlang", data = "phdata.group")}: ... }
\item{emfit.mstep}{\code{signature(model = "herlang")}: ... }
}
}
\examples{
## create a hyper Erlang consisting of two Erlang
## with shape parameters 2 and 3.
(param1 <- herlang(c(2,3)))

## create a hyper Erlang consisting of two Erlang
## with shape parameters 2 and 3.
(param1 <- herlang(shape=c(2,3)))

## create a hyper Erlang with specific parameters
(param2 <- herlang(shape=c(2,3), mixrate=c(0.3,0.7), rate=c(1.0,10.0)))

## convert to a general PH
as(param2, "ph")

## p.d.f. for 0, 0.1, ..., 1
(dherlang(x=seq(0, 1, 0.1), herlang=param2))

## c.d.f. for 0, 0.1, ..., 1
(pherlang(q=seq(0, 1, 0.1), herlang=param2))

## generate 10 samples
(rherlang(n=10, herlang=param2))

}
\seealso{
Classes \code{\linkS4class{ph}} and \code{\linkS4class{cf1}}.
}
\keyword{classes}
