% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{add_layers_control}
\alias{add_layers_control}
\title{Add a layers control to the map}
\usage{
add_layers_control(
  map,
  position = "top-left",
  layers = NULL,
  collapsible = FALSE
)
}
\arguments{
\item{map}{A map object.}

\item{position}{The position of the control on the map (one of "top-left", "top-right", "bottom-left", "bottom-right").}

\item{layers}{A vector of layer IDs to be included in the control. If NULL, all layers will be included.}

\item{collapsible}{Whether the control should be collapsible.}
}
\value{
The modified map object with the layers control added.
}
\description{
Add a layers control to the map
}
\examples{
\dontrun{
library(tigris)
options(tigris_use_cache = TRUE)

rds <- roads("TX", "Tarrant")
tr <- tracts("TX", "Tarrant", cb = TRUE)

maplibre() |>
  fit_bounds(rds) |>
  add_fill_layer(
    id = "Census tracts",
    source = tr,
    fill_color = "purple",
    fill_opacity = 0.6
  ) |>
  add_line_layer(
    "Local roads",
    source = rds,
    line_color = "pink"
  ) |>
  add_layers_control(collapsible = TRUE)

}
}
