% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quickview.R
\name{mapboxgl_view}
\alias{mapboxgl_view}
\title{Quick visualization of geometries with Mapbox GL}
\usage{
mapboxgl_view(
  data,
  color = "navy",
  column = NULL,
  n = NULL,
  palette = viridisLite::viridis,
  style = mapbox_style("light"),
  ...
)
}
\arguments{
\item{data}{An sf object to visualize}

\item{color}{The color used to visualize points, lines, or polygons if \code{column} is NULL.  Defaults to \code{"navy"}.}

\item{column}{The name of the column to visualize. If NULL (default), geometries are shown with default styling.}

\item{n}{Number of quantile breaks for numeric columns. If specified, uses step_expr() instead of interpolate().}

\item{palette}{Color palette function that takes n and returns a character vector of colors. Defaults to viridisLite::viridis.}

\item{style}{The Mapbox style to use. Defaults to mapbox_style("light").}

\item{...}{Additional arguments passed to mapboxgl()}
}
\value{
A Mapbox GL map object
}
\description{
This function provides a quick way to visualize sf geometries using Mapbox GL JS.
It automatically detects the geometry type and applies appropriate styling.
}
\examples{
\dontrun{
library(sf)
nc <- st_read(system.file("shape/nc.shp", package = "sf"))

# Basic view
mapboxgl_view(nc)

# View with column visualization
mapboxgl_view(nc, column = "AREA")

# View with quantile breaks
mapboxgl_view(nc, column = "AREA", n = 5)

# Custom palette examples
mapboxgl_view(nc, column = "AREA", palette = viridisLite::mako)
mapboxgl_view(nc, column = "AREA", palette = function(n) RColorBrewer::brewer.pal(n, "RdYlBu"))
mapboxgl_view(nc, column = "AREA", palette = colorRampPalette(c("red", "white", "blue")))
}
}
