% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_resource.R
\name{get_resources}
\alias{get_resources}
\title{Download specific biodiversity resources}
\usage{
get_resources(x, resources, ...)
}
\arguments{
\item{x}{A biodiversity portfolio object constructed via
\code{init_portfolio()}}

\item{resources}{A character vector indicating the requested resources. All
specified resources must be supported by the package. You can use
\code{available_resources()} to get more information, e.g. additional
required arguments and their default values, about the supported resources.}

\item{...}{Additional arguments required for the requested resources. Check
\code{available_resources()} to learn more about the supported resources and
their arguments.}
}
\value{
Primarily called for the side effect of downloading resources. Returns
the sf portfolio object \code{x} with its attributes amended by the requested resources.
}
\description{
With \code{get_resources()} specific biodiversity data sets required for the
calculation of indicators can be downloaded. The function supports the
specification of several indicators and their respective additional
arguments. You can check the required arguments via
\code{available_resources()}, but the function will gracefully inform you
about any misspecifications.
}
\keyword{function}
