% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register.R, R/get_resources.R,
%   R/calc_indicators.R
\name{mapme}
\alias{mapme}
\alias{mapme_options}
\alias{get_resources}
\alias{calc_indicators}
\title{Portfolio methods for mapme.biodiversity}
\usage{
mapme_options(..., outdir, verbose, aria_bin, testing)

get_resources(x, ...)

calc_indicators(x, ...)
}
\arguments{
\item{...}{One or more functions for resources/indicators}

\item{outdir}{A length one character indicating the output path.}

\item{verbose}{A logical, indicating if informative messages should be printed.}

\item{aria_bin}{A character vector to an aria2c executable for parallel
downloads.}

\item{testing}{A logical. Not to be set by users. Controls the behavior
during automated test pipelines.}

\item{x}{An \code{sf} object with features of type \code{"POLYGON"}}
}
\value{
\code{mapme_options()} returns a list of options if no arguments are specified. Otherwise sets
matching arguments to new values in the package's internal environment.

\code{get_resources()} is called for its side effect of making resources
available in the package environment. Returns \code{x}, invisibly.

\code{calc_indicators()} returns \code{x}, invisibly, with an additional nested
list column per requested indicator.
}
\description{
\code{mapme_options()} sets default options for mapme.biodiversity to control the
behavior of downstream functions.
Mainly, the output path as well as the temporal directory for intermediate
files can be set. Additionally, the verbosity can be set. The testing options
should not be set by users, as it controls the behavior of the package during
automated test pipelines. Might be extended by other options in the future.

\code{get_resources()} data sets required for the
calculation of indicators can be made available. The function supports the
specification of several resource functions. To determine the output path,
temporary directory and verbosity, the output of \code{mapme_options()} is used.

\code{calc_indicators()} calculates specific biodiversity indicators. A
requirement is that the resources that are mandatory inputs for the requested
indicators are available locally. Multiple indicators and their respective
additional arguments can be supplied.
}
\examples{
library(mapme.biodiversity)
mapme_options()
}
